/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinition;

final class EllipticCurveJwkDefinition
extends JwkDefinition {
    private final String x;
    private final String y;
    private final String curve;

    EllipticCurveJwkDefinition(String keyId, JwkDefinition.PublicKeyUse publicKeyUse, JwkDefinition.CryptoAlgorithm algorithm, String x, String y, String curve) {
        super(keyId, JwkDefinition.KeyType.EC, publicKeyUse, algorithm);
        this.x = x;
        this.y = y;
        this.curve = curve;
    }

    String getX() {
        return this.x;
    }

    String getY() {
        return this.y;
    }

    String getCurve() {
        return this.curve;
    }

    static enum NamedCurve {
        P256("P-256"),
        P384("P-384"),
        P521("P-521");

        private final String value;

        private NamedCurve(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }

        static NamedCurve fromValue(String curveName) {
            NamedCurve result = null;
            for (NamedCurve namedCurve : NamedCurve.values()) {
                if (!namedCurve.value().equals(curveName)) continue;
                result = namedCurve;
                break;
            }
            return result;
        }
    }
}

