/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityGenerator;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclPermissionEvaluator
implements PermissionEvaluator {
    private final Log logger = LogFactory.getLog(this.getClass());
    private AclService aclService;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private ObjectIdentityGenerator objectIdentityGenerator = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();

    public AclPermissionEvaluator(AclService aclService) {
        this.aclService = aclService;
    }

    public boolean hasPermission(Authentication authentication, Object domainObject, Object permission) {
        if (domainObject == null) {
            return false;
        }
        ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
        return this.checkPermission(authentication, objectIdentity, permission);
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        ObjectIdentity objectIdentity = this.objectIdentityGenerator.createObjectIdentity(targetId, targetType);
        return this.checkPermission(authentication, objectIdentity, permission);
    }

    private boolean checkPermission(Authentication authentication, ObjectIdentity oid, Object permission) {
        block5: {
            List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
            List<Permission> requiredPermission = this.resolvePermission(permission);
            try {
                Acl acl = this.aclService.readAclById(oid, sids);
                if (acl.isGranted(requiredPermission, sids, false)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Access is granted");
                    }
                    return true;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Returning false - ACLs returned, but insufficient permissions for this principal");
                }
            }
            catch (NotFoundException nfe) {
                if (!this.logger.isDebugEnabled()) break block5;
                this.logger.debug((Object)"Returning false - no ACLs apply for this principal");
            }
        }
        return false;
    }

    List<Permission> resolvePermission(Object permission) {
        if (permission instanceof Integer) {
            return Arrays.asList(BasePermission.buildFromMask((Integer)permission));
        }
        if (permission instanceof Permission) {
            return Arrays.asList((Permission)permission);
        }
        if (permission instanceof Permission[]) {
            return Arrays.asList((Permission[])permission);
        }
        if (permission instanceof String) {
            String permString = (String)permission;
            Permission p = null;
            try {
                p = BasePermission.buildFromName(permString);
            }
            catch (IllegalArgumentException notfound) {
                p = BasePermission.buildFromName(permString.toUpperCase());
            }
            if (p != null) {
                return Arrays.asList(p);
            }
        }
        throw new IllegalArgumentException("unsupported permission: " + permission);
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setObjectIdentityGenerator(ObjectIdentityGenerator objectIdentityGenerator) {
        this.objectIdentityGenerator = objectIdentityGenerator;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }
}

