/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.acls.domain.CumulativePermission;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.Permission;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPermissionFactory
implements PermissionFactory {
    private final Map<Integer, Permission> registeredPermissionsByInteger = new HashMap<Integer, Permission>();
    private final Map<String, Permission> registeredPermissionsByName = new HashMap<String, Permission>();

    public void registerPublicPermissions(Class<? extends Permission> clazz) {
        Assert.notNull(clazz, (String)"Class required");
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Object fieldValue = fields[i].get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass())) continue;
                Permission perm = (Permission)fieldValue;
                String permissionName = fields[i].getName();
                this.registerPermission(perm, permissionName);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void registerPermission(Permission perm, String permissionName) {
        Assert.notNull((Object)perm, (String)"Permission required");
        Assert.hasText((String)permissionName, (String)"Permission name required");
        Integer mask = new Integer(perm.getMask());
        Assert.isTrue((!this.registeredPermissionsByInteger.containsKey(mask) ? 1 : 0) != 0, (String)("An existing Permission already provides mask " + mask));
        Assert.isTrue((!this.registeredPermissionsByName.containsKey(permissionName) ? 1 : 0) != 0, (String)("An existing Permission already provides name '" + permissionName + "'"));
        this.registeredPermissionsByInteger.put(mask, perm);
        this.registeredPermissionsByName.put(permissionName, perm);
    }

    @Override
    public Permission buildFromMask(int mask) {
        if (this.registeredPermissionsByInteger.containsKey(new Integer(mask))) {
            return this.registeredPermissionsByInteger.get(new Integer(mask));
        }
        CumulativePermission permission = new CumulativePermission();
        for (int i = 0; i < 32; ++i) {
            int permissionToCheck = 1 << i;
            if ((mask & permissionToCheck) != permissionToCheck) continue;
            Permission p = this.registeredPermissionsByInteger.get(new Integer(permissionToCheck));
            Assert.state((p != null ? 1 : 0) != 0, (String)("Mask " + permissionToCheck + " does not have a corresponding static Permission"));
            permission.set(p);
        }
        return permission;
    }

    public Permission[] buildFromMask(int[] masks) {
        if (masks == null || masks.length == 0) {
            return new Permission[0];
        }
        Permission[] permissions = new Permission[masks.length];
        for (int i = 0; i < masks.length; ++i) {
            permissions[i] = this.buildFromMask(masks[i]);
        }
        return permissions;
    }

    public Permission buildFromName(String name) {
        Assert.isTrue((boolean)this.registeredPermissionsByName.containsKey(name), (String)("Unknown permission '" + name + "'"));
        return this.registeredPermissionsByName.get(name);
    }

    public Permission[] buildFromName(String[] names) {
        if (names == null || names.length == 0) {
            return new Permission[0];
        }
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = this.buildFromName(names[i]);
        }
        return permissions;
    }
}

