/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.security.acls.domain.IdentityUnavailableException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdentityImpl
implements ObjectIdentity {
    private Class<?> javaType;
    private Serializable identifier;

    public ObjectIdentityImpl(String javaType, Serializable identifier) {
        Assert.hasText((String)javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        try {
            this.javaType = ClassUtils.forName((String)javaType, (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load javaType: " + javaType, e);
        }
        this.identifier = identifier;
    }

    public ObjectIdentityImpl(Class<?> javaType, Serializable identifier) {
        Assert.notNull(javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        this.javaType = javaType;
        this.identifier = identifier;
    }

    public ObjectIdentityImpl(Object object) throws IdentityUnavailableException {
        Object result;
        Assert.notNull((Object)object, (String)"object cannot be null");
        this.javaType = ClassUtils.getUserClass(object.getClass());
        try {
            Method method = this.javaType.getMethod("getId", new Class[0]);
            result = method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IdentityUnavailableException("Could not extract identity from object " + object, e);
        }
        Assert.notNull((Object)result, (String)"getId() is required to return a non-null value");
        Assert.isInstanceOf(Serializable.class, (Object)result, (String)"Getter must provide a return value of type Serializable");
        this.identifier = (Serializable)result;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof ObjectIdentityImpl)) {
            return false;
        }
        ObjectIdentityImpl other = (ObjectIdentityImpl)arg0;
        if (this.identifier instanceof Number && other.identifier instanceof Number ? ((Number)this.identifier).longValue() != ((Number)other.identifier).longValue() : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.javaType.equals(other.javaType);
    }

    @Override
    public Serializable getIdentifier() {
        return this.identifier;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public int hashCode() {
        int code = 31;
        code ^= this.javaType.hashCode();
        return code ^= this.identifier.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        sb.append("Java Type: ").append(this.javaType.getName());
        sb.append("; Identifier: ").append(this.identifier).append("]");
        return sb.toString();
    }
}

