/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAclService
implements AclService {
    protected static final Log log = LogFactory.getLog(JdbcAclService.class);
    private static final String selectAclObjectWithParent = "select obj.object_id_identity as obj_id, class.class as class from acl_object_identity obj, acl_object_identity parent, acl_class class where obj.parent_object = parent.id and obj.object_id_class = class.id and parent.object_id_identity = ? and parent.object_id_class = (select id FROM acl_class where acl_class.class = ?)";
    protected JdbcTemplate jdbcTemplate;
    private LookupStrategy lookupStrategy;

    public JdbcAclService(DataSource dataSource, LookupStrategy lookupStrategy) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        Assert.notNull((Object)lookupStrategy, (String)"LookupStrategy required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.lookupStrategy = lookupStrategy;
    }

    @Override
    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        Object[] args = new Object[]{parentIdentity.getIdentifier(), parentIdentity.getJavaType().getName()};
        List objects = this.jdbcTemplate.query(selectAclObjectWithParent, args, (RowMapper)new RowMapper<ObjectIdentity>(){

            public ObjectIdentity mapRow(ResultSet rs, int rowNum) throws SQLException {
                String javaType = rs.getString("class");
                Long identifier = new Long(rs.getLong("obj_id"));
                return new ObjectIdentityImpl(javaType, (Serializable)identifier);
            }
        });
        if (objects.size() == 0) {
            return null;
        }
        return objects;
    }

    @Override
    public Acl readAclById(ObjectIdentity object, List<Sid> sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> map = this.readAclsById(Arrays.asList(object), sids);
        Assert.isTrue((boolean)map.containsKey(object), (String)("There should have been an Acl entry for ObjectIdentity " + object));
        return map.get(object);
    }

    @Override
    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        return this.readAclById(object, null);
    }

    @Override
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    @Override
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects, List<Sid> sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> result = this.lookupStrategy.readAclsById(objects, sids);
        for (int i = 0; i < objects.size(); ++i) {
            if (result.containsKey(objects.get(i))) continue;
            throw new NotFoundException("Unable to find ACL information for object identity '" + objects.get(i) + "'");
        }
        return result;
    }
}

