/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.web.authentication;

import java.net.MalformedURLException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.web.authentication.DefaultServiceAuthenticationDetails;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAuthenticationDetailsSource
implements AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails>,
ApplicationContextAware {
    private final Pattern artifactPattern;
    private ServiceProperties serviceProperties;

    @Deprecated
    public ServiceAuthenticationDetailsSource() {
        this("ticket");
    }

    public ServiceAuthenticationDetailsSource(ServiceProperties serviceProperties) {
        this(serviceProperties, "ticket");
    }

    public ServiceAuthenticationDetailsSource(String artifactParameterName) {
        this.artifactPattern = DefaultServiceAuthenticationDetails.createArtifactPattern(artifactParameterName);
    }

    public ServiceAuthenticationDetailsSource(ServiceProperties serviceProperties, String artifactParameterName) {
        Assert.notNull((Object)serviceProperties, (String)"serviceProperties cannot be null");
        this.serviceProperties = serviceProperties;
        this.artifactPattern = DefaultServiceAuthenticationDetails.createArtifactPattern(artifactParameterName);
    }

    public ServiceAuthenticationDetails buildDetails(HttpServletRequest context) {
        try {
            return new DefaultServiceAuthenticationDetails(this.serviceProperties.getService(), context, this.artifactPattern);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.serviceProperties == null) {
            this.serviceProperties = (ServiceProperties)applicationContext.getBean(ServiceProperties.class);
        }
    }
}

