/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.JdbcUserServiceBeanDefinitionParser;
import org.springframework.security.config.LdapUserServiceBeanDefinitionParser;
import org.springframework.security.config.PasswordEncoderParser;
import org.springframework.security.config.UserServiceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class AuthenticationProviderBeanDefinitionParser
implements BeanDefinitionParser {
    private static String ATT_USER_DETAILS_REF = "user-service-ref";

    AuthenticationProviderBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition authProvider = new RootBeanDefinition(DaoAuthenticationProvider.class);
        authProvider.setRole(2);
        authProvider.setSource(parserContext.extractSource((Object)element));
        Element passwordEncoderElt = DomUtils.getChildElementByTagName((Element)element, (String)"password-encoder");
        if (passwordEncoderElt != null) {
            PasswordEncoderParser pep = new PasswordEncoderParser(passwordEncoderElt, parserContext);
            authProvider.getPropertyValues().addPropertyValue("passwordEncoder", (Object)pep.getPasswordEncoder());
            if (pep.getSaltSource() != null) {
                authProvider.getPropertyValues().addPropertyValue("saltSource", (Object)pep.getSaltSource());
            }
        }
        Element userServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"user-service");
        Element jdbcUserServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"jdbc-user-service");
        Element ldapUserServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"ldap-user-service");
        String id = parserContext.getReaderContext().generateBeanName((BeanDefinition)authProvider);
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)authProvider);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)authProvider, id));
        String ref = element.getAttribute(ATT_USER_DETAILS_REF);
        if (StringUtils.hasText((String)ref)) {
            if (userServiceElt != null || jdbcUserServiceElt != null || ldapUserServiceElt != null) {
                parserContext.getReaderContext().error("The " + ATT_USER_DETAILS_REF + " attribute cannot be used in combination with child" + "elements '" + "user-service" + "', '" + "jdbc-user-service" + "' or '" + "ldap-user-service" + "'", (Object)element);
            }
        } else {
            AbstractUserDetailsServiceBeanDefinitionParser parser = null;
            Element elt = null;
            if (userServiceElt != null) {
                elt = userServiceElt;
                parser = new UserServiceBeanDefinitionParser();
            } else if (jdbcUserServiceElt != null) {
                elt = jdbcUserServiceElt;
                parser = new JdbcUserServiceBeanDefinitionParser();
            } else if (ldapUserServiceElt != null) {
                elt = ldapUserServiceElt;
                parser = new LdapUserServiceBeanDefinitionParser();
            } else {
                parserContext.getReaderContext().error("A user-service is required", (Object)element);
            }
            parser.parse(elt, parserContext);
            ref = parser.getId();
        }
        authProvider.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(ref));
        BeanDefinitionBuilder cacheResolverBldr = BeanDefinitionBuilder.rootBeanDefinition(AuthenticationProviderCacheResolver.class);
        cacheResolverBldr.addConstructorArgValue((Object)id);
        cacheResolverBldr.addConstructorArgValue((Object)ref);
        cacheResolverBldr.setRole(2);
        AbstractBeanDefinition cacheResolver = cacheResolverBldr.getBeanDefinition();
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)cacheResolver);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)cacheResolver);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)cacheResolver, name));
        ConfigUtils.addAuthenticationProvider(parserContext, id);
        return null;
    }

    static class AuthenticationProviderCacheResolver
    implements BeanFactoryPostProcessor,
    Ordered {
        private String providerId;
        private String userServiceId;

        public AuthenticationProviderCacheResolver(String providerId, String userServiceId) {
            this.providerId = providerId;
            this.userServiceId = userServiceId;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            RootBeanDefinition provider = (RootBeanDefinition)beanFactory.getBeanDefinition(this.providerId);
            String cachingId = this.userServiceId + ".caching";
            if (beanFactory.containsBeanDefinition(cachingId)) {
                RootBeanDefinition cachingUserService = (RootBeanDefinition)beanFactory.getBeanDefinition(cachingId);
                PropertyValue userCacheProperty = cachingUserService.getPropertyValues().getPropertyValue("userCache");
                provider.getPropertyValues().addPropertyValue(userCacheProperty);
            }
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

