/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.FilterChainProxyPostProcessor;
import org.springframework.security.config.NamespaceAuthenticationManager;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConfigUtils {
    ConfigUtils() {
    }

    static void registerDefaultMethodAccessManagerIfNecessary(ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_defaultMethodAccessManager")) {
            parserContext.getRegistry().registerBeanDefinition("_defaultMethodAccessManager", ConfigUtils.createAccessManagerBean(RoleVoter.class, AuthenticatedVoter.class));
        }
    }

    static BeanDefinition createAccessManagerBean(Class<? extends AccessDecisionVoter> ... voters) {
        ManagedList defaultVoters = new ManagedList(voters.length);
        for (Class<? extends AccessDecisionVoter> voter : voters) {
            defaultVoters.add((Object)new RootBeanDefinition(voter));
        }
        BeanDefinitionBuilder accessMgrBuilder = BeanDefinitionBuilder.rootBeanDefinition(AffirmativeBased.class);
        accessMgrBuilder.addPropertyValue("decisionVoters", (Object)defaultVoters);
        return accessMgrBuilder.getBeanDefinition();
    }

    public static int countNonEmpty(String[] objects) {
        int nonNulls = 0;
        for (int i = 0; i < objects.length; ++i) {
            if (!StringUtils.hasText((String)objects[i])) continue;
            ++nonNulls;
        }
        return nonNulls;
    }

    static void registerProviderManagerIfNecessary(ParserContext parserContext) {
        if (parserContext.getRegistry().containsBeanDefinition("_authenticationManager")) {
            return;
        }
        RootBeanDefinition authManager = new RootBeanDefinition(NamespaceAuthenticationManager.class);
        authManager.getPropertyValues().addPropertyValue("providerBeanNames", new ArrayList());
        parserContext.getRegistry().registerBeanDefinition("_authenticationManager", (BeanDefinition)authManager);
    }

    static void addAuthenticationProvider(ParserContext parserContext, String beanName) {
        ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        BeanDefinition authManager = parserContext.getRegistry().getBeanDefinition("_authenticationManager");
        ((ArrayList)authManager.getPropertyValues().getPropertyValue("providerBeanNames").getValue()).add(beanName);
    }

    static ManagedList getRegisteredAfterInvocationProviders(ParserContext parserContext) {
        BeanDefinition manager = ConfigUtils.registerAfterInvocationProviderManagerIfNecessary(parserContext);
        return (ManagedList)manager.getPropertyValues().getPropertyValue("providers").getValue();
    }

    private static BeanDefinition registerAfterInvocationProviderManagerIfNecessary(ParserContext parserContext) {
        if (parserContext.getRegistry().containsBeanDefinition("_afterInvocationManager")) {
            return parserContext.getRegistry().getBeanDefinition("_afterInvocationManager");
        }
        RootBeanDefinition manager = new RootBeanDefinition(AfterInvocationProviderManager.class);
        manager.getPropertyValues().addPropertyValue("providers", (Object)new ManagedList());
        parserContext.getRegistry().registerBeanDefinition("_afterInvocationManager", (BeanDefinition)manager);
        return manager;
    }

    private static void registerFilterChainPostProcessorIfNecessary(ParserContext pc) {
        if (pc.getRegistry().containsBeanDefinition("_filterChainProxyPostProcessor")) {
            return;
        }
        RootBeanDefinition filterChainPostProcessor = new RootBeanDefinition(FilterChainProxyPostProcessor.class);
        filterChainPostProcessor.setRole(2);
        pc.getRegistry().registerBeanDefinition("_filterChainProxyPostProcessor", (BeanDefinition)filterChainPostProcessor);
        RootBeanDefinition filterList = new RootBeanDefinition(FilterChainList.class);
        filterList.setRole(2);
        pc.getRegistry().registerBeanDefinition("_filterChainList", (BeanDefinition)filterList);
    }

    static void addHttpFilter(ParserContext pc, BeanMetadataElement filter) {
        ManagedList filters;
        ConfigUtils.registerFilterChainPostProcessorIfNecessary(pc);
        RootBeanDefinition filterList = (RootBeanDefinition)pc.getRegistry().getBeanDefinition("_filterChainList");
        MutablePropertyValues pvs = filterList.getPropertyValues();
        if (pvs.contains("filters")) {
            filters = (ManagedList)pvs.getPropertyValue("filters").getValue();
        } else {
            filters = new ManagedList();
            pvs.addPropertyValue("filters", (Object)filters);
        }
        filters.add((Object)filter);
    }

    static void validateHttpRedirect(String url, ParserContext pc, Object source) {
        if (!StringUtils.hasText((String)url) || UrlUtils.isValidRedirectUrl((String)url) || url.startsWith("$")) {
            return;
        }
        pc.getReaderContext().warning(url + " is not a valid redirect URL (must start with '/' or http(s))", source);
    }

    static void setSessionControllerOnAuthenticationManager(ParserContext pc, String beanName, Element sourceElt) {
        ConfigUtils.registerProviderManagerIfNecessary(pc);
        BeanDefinition authManager = pc.getRegistry().getBeanDefinition("_authenticationManager");
        PropertyValue pv = authManager.getPropertyValues().getPropertyValue("sessionController");
        if (pv != null && pv.getValue() != null) {
            pc.getReaderContext().error("A session controller has already been set on the authentication manager. The <concurrent-session-control> element isn't compatible with a custom session controller", pc.extractSource((Object)sourceElt));
        }
        authManager.getPropertyValues().addPropertyValue("sessionController", (Object)new RuntimeBeanReference(beanName));
    }

    public static class FilterChainList {
        List filters;

        public List getFilters() {
            return this.filters;
        }

        public void setFilters(List filters) {
            this.filters = filters;
        }
    }
}

