/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Jsr250MethodSecurityMetadataSource;
import org.springframework.security.access.annotation.Jsr250Voter;
import org.springframework.security.access.annotation.SecuredAnnotationSecurityMetadataSource;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdviceVoter;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.MethodSecurityInterceptorPostProcessor;
import org.springframework.security.config.ProtectPointcutPostProcessor;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlobalMethodSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    static final String SECURITY_INTERCEPTOR_ID = "_globalMethodSecurityInterceptor";
    static final String INTERCEPTOR_POST_PROCESSOR_ID = "_globalMethodSecurityInterceptorPostProcessor";
    static final String ACCESS_MANAGER_ID = "_globalMethodSecurityAccessManager";
    private static final String DELEGATING_METHOD_DEFINITION_SOURCE_ID = "_delegatingMethodSecurityMetadataSource";
    private static final String EXPRESSION_HANDLER_ID = "_methodExpressionHandler";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_EXPRESSION = "expression";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_RUN_AS_MGR = "run-as-manager-ref";
    private static final String ATT_USE_JSR250 = "jsr250-annotations";
    private static final String ATT_USE_SECURED = "secured-annotations";
    private static final String ATT_USE_PREPOST = "pre-post-annotations";

    GlobalMethodSecurityBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        ManagedList delegates = new ManagedList();
        boolean jsr250Enabled = "enabled".equals(element.getAttribute(ATT_USE_JSR250));
        boolean useSecured = "enabled".equals(element.getAttribute(ATT_USE_SECURED));
        boolean prePostAnnotationsEnabled = "enabled".equals(element.getAttribute(ATT_USE_PREPOST));
        AbstractBeanDefinition preInvocationVoter = null;
        Map<String, List<ConfigAttribute>> pointcutMap = this.parseProtectPointcuts(parserContext, DomUtils.getChildElementsByTagName((Element)element, (String)"protect-pointcut"));
        if (pointcutMap.size() > 0) {
            MapBasedMethodSecurityMetadataSource mapBasedMethodSecurityMetadataSource = new MapBasedMethodSecurityMetadataSource();
            delegates.add((Object)mapBasedMethodSecurityMetadataSource);
            this.registerProtectPointcutPostProcessor(parserContext, pointcutMap, mapBasedMethodSecurityMetadataSource, source);
        }
        if (prePostAnnotationsEnabled) {
            Element prePostElt = DomUtils.getChildElementByTagName((Element)element, (String)"pre-post-annotation-handling");
            Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
            if (prePostElt != null && expressionHandlerElt != null) {
                parserContext.getReaderContext().error("pre-post-annotation-handling and expression-handler cannot be used together ", source);
            }
            BeanDefinitionBuilder preInvocationVoterBldr = BeanDefinitionBuilder.rootBeanDefinition(PreInvocationAuthorizationAdviceVoter.class);
            BeanDefinitionBuilder afterInvocationBldr = BeanDefinitionBuilder.rootBeanDefinition(PostInvocationAdviceProvider.class);
            BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(PrePostAnnotationSecurityMetadataSource.class);
            if (prePostElt != null) {
                String attributeFactoryRef = DomUtils.getChildElementByTagName((Element)prePostElt, (String)"invocation-attribute-factory").getAttribute("ref");
                String preAdviceRef = DomUtils.getChildElementByTagName((Element)prePostElt, (String)"pre-invocation-advice").getAttribute("ref");
                String postAdviceRef = DomUtils.getChildElementByTagName((Element)prePostElt, (String)"post-invocation-advice").getAttribute("ref");
                mds.addConstructorArgReference(attributeFactoryRef);
                preInvocationVoterBldr.addConstructorArgReference(preAdviceRef);
                afterInvocationBldr.addConstructorArgReference(postAdviceRef);
            } else {
                String expressionHandlerRef;
                String string = expressionHandlerRef = expressionHandlerElt == null ? null : expressionHandlerElt.getAttribute("ref");
                if (StringUtils.hasText((String)expressionHandlerRef)) {
                    this.logger.info((Object)("Using bean '" + expressionHandlerRef + "' as method ExpressionHandler implementation"));
                } else {
                    parserContext.getRegistry().registerBeanDefinition(EXPRESSION_HANDLER_ID, (BeanDefinition)new RootBeanDefinition(DefaultMethodSecurityExpressionHandler.class));
                    this.logger.warn((Object)"Expressions were enabled for method security but no SecurityExpressionHandler was configured. All hasPermision() expressions will evaluate to false.");
                    expressionHandlerRef = EXPRESSION_HANDLER_ID;
                }
                BeanDefinitionBuilder expressionPreAdviceBldr = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPreInvocationAdvice.class);
                expressionPreAdviceBldr.addPropertyReference("expressionHandler", expressionHandlerRef);
                preInvocationVoterBldr.addConstructorArgValue((Object)expressionPreAdviceBldr.getBeanDefinition());
                BeanDefinitionBuilder expressionPostAdviceBldr = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPostInvocationAdvice.class);
                expressionPostAdviceBldr.addConstructorArgReference(expressionHandlerRef);
                afterInvocationBldr.addConstructorArgValue((Object)expressionPostAdviceBldr.getBeanDefinition());
                BeanDefinitionBuilder annotationInvocationFactory = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedAnnotationAttributeFactory.class);
                annotationInvocationFactory.addConstructorArgReference(expressionHandlerRef);
                mds.addConstructorArgValue((Object)annotationInvocationFactory.getBeanDefinition());
            }
            preInvocationVoter = preInvocationVoterBldr.getBeanDefinition();
            ConfigUtils.getRegisteredAfterInvocationProviders(parserContext).add((Object)afterInvocationBldr.getBeanDefinition());
            delegates.add((Object)mds.getBeanDefinition());
        }
        if (useSecured) {
            delegates.add((Object)BeanDefinitionBuilder.rootBeanDefinition(SecuredAnnotationSecurityMetadataSource.class).getBeanDefinition());
        }
        if (jsr250Enabled) {
            delegates.add((Object)BeanDefinitionBuilder.rootBeanDefinition(Jsr250MethodSecurityMetadataSource.class).getBeanDefinition());
        }
        this.registerDelegatingMethodSecurityMetadataSource(parserContext, delegates, source);
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            this.registerAccessManager(parserContext, jsr250Enabled, (BeanDefinition)preInvocationVoter);
            accessManagerId = ACCESS_MANAGER_ID;
        }
        String runAsManagerId = element.getAttribute(ATT_RUN_AS_MGR);
        this.registerMethodSecurityInterceptor(parserContext, accessManagerId, runAsManagerId, source);
        this.registerAdvisor(parserContext, source);
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        return null;
    }

    private void registerAccessManager(ParserContext pc, boolean jsr250Enabled, BeanDefinition expressionVoter) {
        BeanDefinitionBuilder accessMgrBuilder = BeanDefinitionBuilder.rootBeanDefinition(AffirmativeBased.class);
        ManagedList voters = new ManagedList(4);
        if (expressionVoter != null) {
            voters.add((Object)expressionVoter);
        }
        voters.add((Object)new RootBeanDefinition(RoleVoter.class));
        voters.add((Object)new RootBeanDefinition(AuthenticatedVoter.class));
        if (jsr250Enabled) {
            voters.add((Object)new RootBeanDefinition(Jsr250Voter.class));
        }
        accessMgrBuilder.addPropertyValue("decisionVoters", (Object)voters);
        pc.getRegistry().registerBeanDefinition(ACCESS_MANAGER_ID, (BeanDefinition)accessMgrBuilder.getBeanDefinition());
    }

    private void registerDelegatingMethodSecurityMetadataSource(ParserContext parserContext, ManagedList delegates, Object source) {
        if (parserContext.getRegistry().containsBeanDefinition(DELEGATING_METHOD_DEFINITION_SOURCE_ID)) {
            parserContext.getReaderContext().error("Duplicate <global-method-security> detected.", source);
        }
        RootBeanDefinition delegatingMethodSecurityMetadataSource = new RootBeanDefinition(DelegatingMethodSecurityMetadataSource.class);
        delegatingMethodSecurityMetadataSource.setRole(2);
        delegatingMethodSecurityMetadataSource.setSource(source);
        delegatingMethodSecurityMetadataSource.getPropertyValues().addPropertyValue("methodSecurityMetadataSources", (Object)delegates);
        parserContext.getRegistry().registerBeanDefinition(DELEGATING_METHOD_DEFINITION_SOURCE_ID, (BeanDefinition)delegatingMethodSecurityMetadataSource);
    }

    private void registerProtectPointcutPostProcessor(ParserContext parserContext, Map<String, List<ConfigAttribute>> pointcutMap, MapBasedMethodSecurityMetadataSource mapBasedMethodSecurityMetadataSource, Object source) {
        RootBeanDefinition ppbp = new RootBeanDefinition(ProtectPointcutPostProcessor.class);
        ppbp.setRole(2);
        ppbp.setSource(source);
        ppbp.getConstructorArgumentValues().addGenericArgumentValue((Object)mapBasedMethodSecurityMetadataSource);
        ppbp.getPropertyValues().addPropertyValue("pointcutMap", pointcutMap);
        parserContext.getRegistry().registerBeanDefinition("_protectPointcutPostProcessor", (BeanDefinition)ppbp);
    }

    private Map<String, List<ConfigAttribute>> parseProtectPointcuts(ParserContext parserContext, List<Element> protectPointcutElts) {
        LinkedHashMap<String, List<ConfigAttribute>> pointcutMap = new LinkedHashMap<String, List<ConfigAttribute>>();
        for (Element childElt : protectPointcutElts) {
            String accessConfig = childElt.getAttribute(ATT_ACCESS);
            String expression = childElt.getAttribute(ATT_EXPRESSION);
            if (!StringUtils.hasText((String)accessConfig)) {
                parserContext.getReaderContext().error("Access configuration required", parserContext.extractSource((Object)childElt));
            }
            if (!StringUtils.hasText((String)expression)) {
                parserContext.getReaderContext().error("Pointcut expression required", parserContext.extractSource((Object)childElt));
            }
            String[] attributeTokens = StringUtils.commaDelimitedListToStringArray((String)accessConfig);
            ArrayList<SecurityConfig> attributes = new ArrayList<SecurityConfig>(attributeTokens.length);
            for (String token : attributeTokens) {
                attributes.add(new SecurityConfig(token));
            }
            pointcutMap.put(expression, attributes);
        }
        return pointcutMap;
    }

    private void registerMethodSecurityInterceptor(ParserContext pc, String accessManagerId, String runAsManagerId, Object source) {
        BeanDefinitionBuilder bldr = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
        bldr.setRole(2);
        bldr.getRawBeanDefinition().setSource(source);
        bldr.addPropertyReference("accessDecisionManager", accessManagerId);
        bldr.addPropertyReference("authenticationManager", "_authenticationManager");
        bldr.addPropertyReference("securityMetadataSource", DELEGATING_METHOD_DEFINITION_SOURCE_ID);
        if (StringUtils.hasText((String)runAsManagerId)) {
            bldr.addPropertyReference("runAsManager", runAsManagerId);
        }
        AbstractBeanDefinition interceptor = bldr.getBeanDefinition();
        pc.getRegistry().registerBeanDefinition(SECURITY_INTERCEPTOR_ID, (BeanDefinition)interceptor);
        pc.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptor, SECURITY_INTERCEPTOR_ID));
        pc.getRegistry().registerBeanDefinition(INTERCEPTOR_POST_PROCESSOR_ID, (BeanDefinition)new RootBeanDefinition(MethodSecurityInterceptorPostProcessor.class));
    }

    private void registerAdvisor(ParserContext parserContext, Object source) {
        RootBeanDefinition advisor = new RootBeanDefinition(MethodSecurityMetadataSourceAdvisor.class);
        advisor.setRole(2);
        advisor.setSource(source);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)SECURITY_INTERCEPTOR_ID);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(DELEGATING_METHOD_DEFINITION_SOURCE_ID));
        parserContext.getRegistry().registerBeanDefinition("_methodSecurityMetadataSourceAdvisor", (BeanDefinition)advisor);
    }
}

