/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.List;
import org.springframework.aop.config.AbstractInterceptorDrivenBeanDefinitionDecorator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InternalInterceptMethodsBeanDefinitionDecorator
extends AbstractInterceptorDrivenBeanDefinitionDecorator {
    static final String ATT_METHOD = "method";
    static final String ATT_ACCESS = "access";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";

    InternalInterceptMethodsBeanDefinitionDecorator() {
    }

    protected BeanDefinition createInterceptorDefinition(Node node) {
        Element interceptMethodsElt = (Element)node;
        BeanDefinitionBuilder interceptor = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
        interceptor.setAutowireMode(2);
        String accessManagerId = interceptMethodsElt.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            accessManagerId = "_defaultMethodAccessManager";
        }
        interceptor.addPropertyValue("accessDecisionManager", (Object)new RuntimeBeanReference(accessManagerId));
        interceptor.addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        Element parent = (Element)node.getParentNode();
        String parentBeanClass = parent.getAttribute("class");
        parent = null;
        List methods = DomUtils.getChildElementsByTagName((Element)interceptMethodsElt, (String)"protect");
        StringBuffer sb = new StringBuffer();
        for (Element protectmethodElt : methods) {
            String accessConfig = protectmethodElt.getAttribute(ATT_ACCESS);
            String methodName = protectmethodElt.getAttribute(ATT_METHOD);
            if (methodName.lastIndexOf(".") == -1 && parentBeanClass != null && !"".equals(parentBeanClass)) {
                methodName = parentBeanClass + "." + methodName;
            }
            sb.append(methodName + "=" + accessConfig).append("\r\n");
        }
        interceptor.addPropertyValue("securityMetadataSource", (Object)sb.toString());
        return interceptor.getBeanDefinition();
    }
}

