/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.access.intercept.AfterInvocationManager;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;

public class MethodSecurityInterceptorPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!"_globalMethodSecurityInterceptor".equals(beanName)) {
            return bean;
        }
        MethodSecurityInterceptor interceptor = (MethodSecurityInterceptor)bean;
        if (this.beanFactory.containsBean("_afterInvocationManager")) {
            this.logger.debug((Object)"Setting AfterInvocationManaer on MethodSecurityInterceptor");
            interceptor.setAfterInvocationManager((AfterInvocationManager)this.beanFactory.getBean("_afterInvocationManager"));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

