/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.security.config.CachingUserDetailsService;
import org.springframework.security.config.SecurityConfigurationException;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.util.Assert;

public class UserDetailsServiceInjectionBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if ("_x509AuthenticationProvider".equals(beanName)) {
            this.injectUserDetailsServiceIntoX509Provider((PreAuthenticatedAuthenticationProvider)bean);
        } else if ("_rememberMeServices".equals(beanName)) {
            this.injectUserDetailsServiceIntoRememberMeServices((AbstractRememberMeServices)bean);
        } else if ("_openIDAuthenticationProvider".equals(beanName)) {
            this.injectUserDetailsServiceIntoOpenIDProvider(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void injectUserDetailsServiceIntoRememberMeServices(AbstractRememberMeServices services) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition("_rememberMeServices");
        PropertyValue pv = beanDefinition.getPropertyValues().getPropertyValue("userDetailsService");
        if (pv == null) {
            services.setUserDetailsService(this.getUserDetailsService());
        } else {
            UserDetailsService cachingUserService = this.getCachingUserService(pv.getValue());
            if (cachingUserService != null) {
                services.setUserDetailsService(cachingUserService);
            }
        }
    }

    private void injectUserDetailsServiceIntoX509Provider(PreAuthenticatedAuthenticationProvider provider) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition("_x509AuthenticationProvider");
        PropertyValue pv = beanDefinition.getPropertyValues().getPropertyValue("preAuthenticatedUserDetailsService");
        UserDetailsByNameServiceWrapper wrapper = new UserDetailsByNameServiceWrapper();
        if (pv == null) {
            wrapper.setUserDetailsService(this.getUserDetailsService());
            provider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)wrapper);
        } else {
            RootBeanDefinition preAuthUserService = (RootBeanDefinition)pv.getValue();
            Object userService = preAuthUserService.getPropertyValues().getPropertyValue("userDetailsService").getValue();
            UserDetailsService cachingUserService = this.getCachingUserService(userService);
            if (cachingUserService != null) {
                wrapper.setUserDetailsService(cachingUserService);
                provider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)wrapper);
            }
        }
    }

    private void injectUserDetailsServiceIntoOpenIDProvider(Object bean) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition("_openIDAuthenticationProvider");
        PropertyValue pv = beanDefinition.getPropertyValues().getPropertyValue("userDetailsService");
        if (pv == null) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
            beanWrapper.setPropertyValue("userDetailsService", (Object)this.getUserDetailsService());
        }
    }

    UserDetailsService getUserDetailsService() {
        Map beans = this.beanFactory.getBeansOfType(CachingUserDetailsService.class);
        if (beans.size() == 0) {
            beans = this.beanFactory.getBeansOfType(UserDetailsService.class);
        }
        if (beans.size() == 0) {
            throw new SecurityConfigurationException("No UserDetailsService registered.");
        }
        if (beans.size() > 1) {
            throw new SecurityConfigurationException("More than one UserDetailsService registered. Please use a specific Id reference in <remember-me/> <openid-login/> or <x509 /> elements.");
        }
        return (UserDetailsService)beans.values().toArray()[0];
    }

    private UserDetailsService getCachingUserService(Object userServiceRef) {
        Assert.isInstanceOf(RuntimeBeanReference.class, (Object)userServiceRef, (String)"userDetailsService property value must be a RuntimeBeanReference");
        String id = ((RuntimeBeanReference)userServiceRef).getBeanName();
        String cachingId = id + ".caching";
        if (this.beanFactory.containsBeanDefinition(cachingId)) {
            return (UserDetailsService)this.beanFactory.getBean(cachingId);
        }
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

