/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class X509BeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ATT_REGEX = "subject-principal-regex";
    public static final String ATT_USER_SERVICE_REF = "user-service-ref";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(X509PreAuthenticatedProcessingFilter.class);
        RootBeanDefinition entryPoint = new RootBeanDefinition(Http403ForbiddenEntryPoint.class);
        Object source = parserContext.extractSource((Object)element);
        filterBuilder.getRawBeanDefinition().setSource(source);
        entryPoint.setSource(source);
        String regex = element.getAttribute(ATT_REGEX);
        if (StringUtils.hasText((String)regex)) {
            SubjectDnX509PrincipalExtractor extractor = new SubjectDnX509PrincipalExtractor();
            extractor.setSubjectDnRegex(regex);
            filterBuilder.addPropertyValue("principalExtractor", (Object)extractor);
        }
        RootBeanDefinition provider = new RootBeanDefinition(PreAuthenticatedAuthenticationProvider.class);
        parserContext.getRegistry().registerBeanDefinition("_x509AuthenticationProvider", (BeanDefinition)provider);
        ConfigUtils.addAuthenticationProvider(parserContext, "_x509AuthenticationProvider");
        String userServiceRef = element.getAttribute(ATT_USER_SERVICE_REF);
        if (StringUtils.hasText((String)userServiceRef)) {
            RootBeanDefinition preAuthUserService = new RootBeanDefinition(UserDetailsByNameServiceWrapper.class);
            preAuthUserService.setSource(source);
            preAuthUserService.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(userServiceRef));
            provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", (Object)preAuthUserService);
        }
        parserContext.getRegistry().registerBeanDefinition("_preAuthenticatedProcessingFilterEntryPoint", (BeanDefinition)entryPoint);
        filterBuilder.addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        parserContext.getRegistry().registerBeanDefinition("_x509ProcessingFilter", (BeanDefinition)filterBuilder.getBeanDefinition());
        ConfigUtils.addHttpFilter(parserContext, (BeanMetadataElement)new RuntimeBeanReference("_x509ProcessingFilter"));
        return null;
    }
}

