/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.OrderComparator;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.authentication.AuthenticationManagerFactoryBean;
import org.springframework.security.config.http.AuthenticationConfigBuilder;
import org.springframework.security.config.http.DefaultFilterChainValidator;
import org.springframework.security.config.http.HttpConfigurationBuilder;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.PortMappingsBeanDefinitionParser;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.util.AnyRequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(HttpSecurityBeanDefinitionParser.class);
    static final String ATT_PATH_PATTERN = "pattern";
    static final String ATT_HTTP_METHOD = "method";
    static final String ATT_FILTERS = "filters";
    static final String OPT_FILTERS_NONE = "none";
    static final String ATT_REQUIRES_CHANNEL = "requires-channel";
    private static final String ATT_REF = "ref";
    private static final String ATT_SECURED = "security";
    private static final String OPT_SECURITY_NONE = "none";

    public BeanDefinition parse(Element element, ParserContext pc) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        MatcherType matcherType = MatcherType.fromElement(element);
        ManagedMap filterChainMap = new ManagedMap();
        String filterChainPattern = element.getAttribute(ATT_PATH_PATTERN);
        Object filterChainMatcher = StringUtils.hasText((String)filterChainPattern) ? matcherType.createMatcher(filterChainPattern, null) : new RootBeanDefinition(AnyRequestMatcher.class);
        filterChainMap.put(filterChainMatcher, this.createFilterChain(element, pc, matcherType));
        this.registerFilterChainProxy(pc, (Map<BeanDefinition, List<BeanMetadataElement>>)filterChainMap, pc.extractSource((Object)element));
        pc.popAndRegisterContainingComponent();
        return null;
    }

    List<BeanMetadataElement> createFilterChain(Element element, ParserContext pc, MatcherType matcherType) {
        boolean secured;
        boolean bl = secured = !"none".equals(element.getAttribute(ATT_SECURED));
        if (!secured) {
            if (!StringUtils.hasText((String)element.getAttribute(ATT_PATH_PATTERN))) {
                pc.getReaderContext().error("The 'security' attribute must be used in combination with the 'pattern' attribute.", pc.extractSource((Object)element));
            }
            for (int n = 0; n < element.getChildNodes().getLength(); ++n) {
                if (!(element.getChildNodes().item(n) instanceof Element)) continue;
                pc.getReaderContext().error("If you are using <http> to define an unsecured pattern, it cannot contain child elements.", pc.extractSource((Object)element));
            }
            return Collections.emptyList();
        }
        String portMapperName = this.createPortMapper(element, pc);
        ManagedList authenticationProviders = new ManagedList();
        BeanReference authenticationManager = this.createAuthenticationManager(element, pc, (ManagedList<BeanReference>)authenticationProviders);
        HttpConfigurationBuilder httpBldr = new HttpConfigurationBuilder(element, pc, matcherType, portMapperName, authenticationManager);
        AuthenticationConfigBuilder authBldr = new AuthenticationConfigBuilder(element, pc, httpBldr.getSessionCreationPolicy(), httpBldr.getRequestCache(), authenticationManager, httpBldr.getSessionStrategy());
        authenticationProviders.addAll(authBldr.getProviders());
        ArrayList<OrderDecorator> unorderedFilterChain = new ArrayList<OrderDecorator>();
        unorderedFilterChain.addAll(httpBldr.getFilters());
        unorderedFilterChain.addAll(authBldr.getFilters());
        unorderedFilterChain.addAll(this.buildCustomFilterList(element, pc));
        Collections.sort(unorderedFilterChain, new OrderComparator());
        this.checkFilterChainOrder(unorderedFilterChain, pc, pc.extractSource((Object)element));
        ManagedList filterChain = new ManagedList();
        for (OrderDecorator od : unorderedFilterChain) {
            filterChain.add(od.bean);
        }
        return filterChain;
    }

    private String createPortMapper(Element elt, ParserContext pc) {
        BeanDefinition portMapper = new PortMappingsBeanDefinitionParser().parse(DomUtils.getChildElementByTagName((Element)elt, (String)"port-mappings"), pc);
        String portMapperName = pc.getReaderContext().generateBeanName(portMapper);
        pc.registerBeanComponent(new BeanComponentDefinition(portMapper, portMapperName));
        return portMapperName;
    }

    private BeanReference createAuthenticationManager(Element element, ParserContext pc, ManagedList<BeanReference> authenticationProviders) {
        BeanDefinitionBuilder authManager = BeanDefinitionBuilder.rootBeanDefinition(ProviderManager.class);
        authManager.addPropertyValue("parent", (Object)new RootBeanDefinition(AuthenticationManagerFactoryBean.class));
        authManager.addPropertyValue("providers", authenticationProviders);
        RootBeanDefinition clearCredentials = new RootBeanDefinition(MethodInvokingFactoryBean.class);
        clearCredentials.getPropertyValues().addPropertyValue("targetObject", (Object)new RootBeanDefinition(AuthenticationManagerFactoryBean.class));
        clearCredentials.getPropertyValues().addPropertyValue("targetMethod", (Object)"isEraseCredentialsAfterAuthentication");
        authManager.addPropertyValue("eraseCredentialsAfterAuthentication", (Object)clearCredentials);
        authManager.getRawBeanDefinition().setSource(pc.extractSource((Object)element));
        AbstractBeanDefinition authMgrBean = authManager.getBeanDefinition();
        String id = pc.getReaderContext().generateBeanName((BeanDefinition)authMgrBean);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)authMgrBean, id));
        return new RuntimeBeanReference(id);
    }

    private void checkFilterChainOrder(List<OrderDecorator> filters, ParserContext pc, Object source) {
        logger.info((Object)("Checking sorted filter chain: " + filters));
        for (int i = 0; i < filters.size(); ++i) {
            OrderDecorator filter = filters.get(i);
            if (i <= 0) continue;
            OrderDecorator previous = filters.get(i - 1);
            if (filter.getOrder() != previous.getOrder()) continue;
            pc.getReaderContext().error("Filter beans '" + filter.bean + "' and '" + previous.bean + "' have the same 'order' value. When using custom filters, " + "please make sure the positions do not conflict with default filters. " + "Alternatively you can disable the default filters by removing the corresponding " + "child elements from <http> and avoiding the use of <http auto-config='true'>.", source);
        }
    }

    List<OrderDecorator> buildCustomFilterList(Element element, ParserContext pc) {
        List customFilterElts = DomUtils.getChildElementsByTagName((Element)element, (String)"custom-filter");
        ArrayList<OrderDecorator> customFilters = new ArrayList<OrderDecorator>();
        String ATT_AFTER = "after";
        String ATT_BEFORE = "before";
        String ATT_POSITION = "position";
        for (Element elt : customFilterElts) {
            SecurityFilters order;
            String after = elt.getAttribute("after");
            String before = elt.getAttribute("before");
            String position = elt.getAttribute("position");
            String ref = elt.getAttribute(ATT_REF);
            if (!StringUtils.hasText((String)ref)) {
                pc.getReaderContext().error("The 'ref' attribute must be supplied", pc.extractSource((Object)elt));
            }
            RuntimeBeanReference bean = new RuntimeBeanReference(ref);
            if (WebConfigUtils.countNonEmpty(new String[]{after, before, position}) != 1) {
                pc.getReaderContext().error("A single 'after', 'before', or 'position' attribute must be supplied", pc.extractSource((Object)elt));
            }
            if (StringUtils.hasText((String)position)) {
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.valueOf(position)));
                continue;
            }
            if (StringUtils.hasText((String)after)) {
                order = SecurityFilters.valueOf(after);
                if (order == SecurityFilters.LAST) {
                    customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.LAST));
                    continue;
                }
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, order.getOrder() + 1));
                continue;
            }
            if (!StringUtils.hasText((String)before)) continue;
            order = SecurityFilters.valueOf(before);
            if (order == SecurityFilters.FIRST) {
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.FIRST));
                continue;
            }
            customFilters.add(new OrderDecorator((BeanMetadataElement)bean, order.getOrder() - 1));
        }
        return customFilters;
    }

    private void registerFilterChainProxy(ParserContext pc, Map<BeanDefinition, List<BeanMetadataElement>> filterChainMap, Object source) {
        if (pc.getRegistry().containsBeanDefinition("org.springframework.security.filterChainProxy")) {
            BeanDefinition fcp = pc.getRegistry().getBeanDefinition("org.springframework.security.filterChainProxy");
            Map existingFilterChainMap = (Map)fcp.getPropertyValues().getPropertyValue("filterChainMap").getValue();
            for (BeanDefinition matcherBean : filterChainMap.keySet()) {
                if (!existingFilterChainMap.containsKey(matcherBean)) continue;
                Map args = matcherBean.getConstructorArgumentValues().getIndexedArgumentValues();
                pc.getReaderContext().error("The filter chain map already contains this request matcher [" + ((ConstructorArgumentValues.ValueHolder)args.get(0)).getValue() + ", " + ((ConstructorArgumentValues.ValueHolder)args.get(1)).getValue() + "]", source);
            }
            existingFilterChainMap.putAll(filterChainMap);
        } else {
            BeanDefinitionBuilder fcpBldr = BeanDefinitionBuilder.rootBeanDefinition(FilterChainProxy.class);
            fcpBldr.getRawBeanDefinition().setSource(source);
            fcpBldr.addPropertyValue("filterChainMap", filterChainMap);
            fcpBldr.addPropertyValue("filterChainValidator", (Object)new RootBeanDefinition(DefaultFilterChainValidator.class));
            AbstractBeanDefinition fcpBean = fcpBldr.getBeanDefinition();
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)fcpBean, "org.springframework.security.filterChainProxy"));
            pc.getRegistry().registerAlias("org.springframework.security.filterChainProxy", "springSecurityFilterChain");
        }
    }
}

