/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherConfigurer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.FilterComparator;
import org.springframework.security.config.annotation.web.configurers.AnonymousConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.JeeConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.PortMapperConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.config.annotation.web.configurers.SecurityContextConfigurer;
import org.springframework.security.config.annotation.web.configurers.ServletApiConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.X509Configurer;
import org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.security.web.util.AnyRequestMatcher;
import org.springframework.security.web.util.RegexRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpSecurity
extends AbstractConfiguredSecurityBuilder<DefaultSecurityFilterChain, HttpSecurity>
implements SecurityBuilder<DefaultSecurityFilterChain>,
HttpSecurityBuilder<HttpSecurity> {
    private final RequestMatcherConfigurer requestMatcherConfigurer = new RequestMatcherConfigurer();
    private List<Filter> filters = new ArrayList<Filter>();
    private RequestMatcher requestMatcher = new AnyRequestMatcher();
    private FilterComparator comparitor = new FilterComparator();

    public HttpSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationManagerBuilder authenticationBuilder, Map<Class<Object>, Object> sharedObjects) {
        super(objectPostProcessor);
        Assert.notNull((Object)authenticationBuilder, (String)"authenticationBuilder cannot be null");
        this.setSharedObject(AuthenticationManagerBuilder.class, authenticationBuilder);
        for (Map.Entry<Class<Object>, Object> entry : sharedObjects.entrySet()) {
            this.setSharedObject(entry.getKey(), entry.getValue());
        }
    }

    public OpenIDLoginConfigurer<HttpSecurity> openidLogin() throws Exception {
        return this.getOrApply(new OpenIDLoginConfigurer());
    }

    public HeadersConfigurer<HttpSecurity> headers() throws Exception {
        return this.getOrApply(new HeadersConfigurer());
    }

    public SessionManagementConfigurer<HttpSecurity> sessionManagement() throws Exception {
        return this.getOrApply(new SessionManagementConfigurer());
    }

    public PortMapperConfigurer<HttpSecurity> portMapper() throws Exception {
        return this.getOrApply(new PortMapperConfigurer());
    }

    public JeeConfigurer<HttpSecurity> jee() throws Exception {
        return this.getOrApply(new JeeConfigurer());
    }

    public X509Configurer<HttpSecurity> x509() throws Exception {
        return this.getOrApply(new X509Configurer());
    }

    public RememberMeConfigurer<HttpSecurity> rememberMe() throws Exception {
        return this.getOrApply(new RememberMeConfigurer());
    }

    public ExpressionUrlAuthorizationConfigurer<HttpSecurity> authorizeRequests() throws Exception {
        return this.getOrApply(new ExpressionUrlAuthorizationConfigurer());
    }

    public RequestCacheConfigurer<HttpSecurity> requestCache() throws Exception {
        return this.getOrApply(new RequestCacheConfigurer());
    }

    public ExceptionHandlingConfigurer<HttpSecurity> exceptionHandling() throws Exception {
        return this.getOrApply(new ExceptionHandlingConfigurer());
    }

    public SecurityContextConfigurer<HttpSecurity> securityContext() throws Exception {
        return this.getOrApply(new SecurityContextConfigurer());
    }

    public ServletApiConfigurer<HttpSecurity> servletApi() throws Exception {
        return this.getOrApply(new ServletApiConfigurer());
    }

    public CsrfConfigurer<HttpSecurity> csrf() throws Exception {
        return this.getOrApply(new CsrfConfigurer());
    }

    public LogoutConfigurer<HttpSecurity> logout() throws Exception {
        return this.getOrApply(new LogoutConfigurer());
    }

    public AnonymousConfigurer<HttpSecurity> anonymous() throws Exception {
        return this.getOrApply(new AnonymousConfigurer());
    }

    public FormLoginConfigurer<HttpSecurity> formLogin() throws Exception {
        return this.getOrApply(new FormLoginConfigurer());
    }

    public ChannelSecurityConfigurer<HttpSecurity> requiresChannel() throws Exception {
        return this.getOrApply(new ChannelSecurityConfigurer());
    }

    public HttpBasicConfigurer<HttpSecurity> httpBasic() throws Exception {
        return this.getOrApply(new HttpBasicConfigurer());
    }

    @Override
    protected void beforeConfigure() throws Exception {
        this.setSharedObject(AuthenticationManager.class, this.getAuthenticationRegistry().build());
    }

    @Override
    protected DefaultSecurityFilterChain performBuild() throws Exception {
        Collections.sort(this.filters, this.comparitor);
        return new DefaultSecurityFilterChain(this.requestMatcher, this.filters);
    }

    @Override
    public HttpSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    @Override
    public HttpSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    @Override
    public HttpSecurity addFilterAfter(Filter filter, Class<? extends Filter> afterFilter) {
        this.comparitor.registerAfter(filter.getClass(), afterFilter);
        return this.addFilter(filter);
    }

    @Override
    public HttpSecurity addFilterBefore(Filter filter, Class<? extends Filter> beforeFilter) {
        this.comparitor.registerBefore(filter.getClass(), beforeFilter);
        return this.addFilter(filter);
    }

    @Override
    public HttpSecurity addFilter(Filter filter) {
        Class<?> filterClass = filter.getClass();
        if (!this.comparitor.isRegistered(filterClass)) {
            throw new IllegalArgumentException("The Filter class " + filterClass.getName() + " does not have a registered order and cannot be added without a specified order. Consider using addFilterBefore or addFilterAfter instead.");
        }
        this.filters.add(filter);
        return this;
    }

    public RequestMatcherConfigurer requestMatchers() {
        return this.requestMatcherConfigurer;
    }

    public HttpSecurity requestMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        return this;
    }

    public HttpSecurity antMatcher(String antPattern) {
        return this.requestMatcher((RequestMatcher)new AntPathRequestMatcher(antPattern));
    }

    public HttpSecurity regexMatcher(String pattern) {
        return this.requestMatcher((RequestMatcher)new RegexRequestMatcher(pattern, null));
    }

    private <C extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        return this.apply(configurer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrRequestMatcher
    implements RequestMatcher {
        private final List<RequestMatcher> requestMatchers;

        private OrRequestMatcher(List<RequestMatcher> requestMatchers) {
            this.requestMatchers = requestMatchers;
        }

        public boolean matches(HttpServletRequest request) {
            for (RequestMatcher matcher : this.requestMatchers) {
                if (!matcher.matches(request)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class RequestMatcherConfigurer
    extends AbstractRequestMatcherConfigurer<HttpSecurity, RequestMatcherConfigurer, DefaultSecurityFilterChain> {
        @Override
        protected RequestMatcherConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            HttpSecurity.this.requestMatcher(new OrRequestMatcher(requestMatchers));
            return this;
        }

        @Override
        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        private RequestMatcherConfigurer() {
        }
    }
}

