/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsrfConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<CsrfConfigurer<H>, H> {
    private CsrfTokenRepository csrfTokenRepository = new HttpSessionCsrfTokenRepository();
    private RequestMatcher requireCsrfProtectionMatcher;

    public CsrfConfigurer<H> csrfTokenRepository(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, (String)"csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
        return this;
    }

    public CsrfConfigurer<H> requireCsrfProtectionMatcher(RequestMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)this.csrfTokenRepository, (String)"requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        SessionManagementConfigurer sessionConfigurer;
        LogoutConfigurer logoutConfigurer;
        AccessDeniedHandler accessDeniedHandler;
        ExceptionHandlingConfigurer exceptionConfig;
        CsrfFilter filter = new CsrfFilter(this.csrfTokenRepository);
        if (this.requireCsrfProtectionMatcher != null) {
            filter.setRequireCsrfProtectionMatcher(this.requireCsrfProtectionMatcher);
        }
        if ((exceptionConfig = http.getConfigurer(ExceptionHandlingConfigurer.class)) != null && (accessDeniedHandler = exceptionConfig.getAccessDeniedHandler()) != null) {
            filter.setAccessDeniedHandler(accessDeniedHandler);
        }
        if ((logoutConfigurer = http.getConfigurer(LogoutConfigurer.class)) != null) {
            logoutConfigurer.addLogoutHandler((LogoutHandler)new CsrfLogoutHandler(this.csrfTokenRepository));
        }
        if ((sessionConfigurer = http.getConfigurer(SessionManagementConfigurer.class)) != null) {
            sessionConfigurer.addSessionAuthenticationStrategy((SessionAuthenticationStrategy)new CsrfAuthenticationStrategy(this.csrfTokenRepository));
        }
        filter = this.postProcess(filter);
        http.addFilter((Filter)filter);
    }
}

