/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.PermitAllSupport;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.ui.DefaultLoginPageViewFilter;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogoutConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<LogoutConfigurer<H>, H> {
    private List<LogoutHandler> logoutHandlers = new ArrayList<LogoutHandler>();
    private SecurityContextLogoutHandler contextLogoutHandler = new SecurityContextLogoutHandler();
    private String logoutSuccessUrl = "/login?logout";
    private LogoutSuccessHandler logoutSuccessHandler;
    private RequestMatcher logoutRequestMatcher = new AntPathRequestMatcher("/logout", "POST");
    private boolean permitAll;
    private boolean customLogoutSuccess;

    public LogoutConfigurer<H> addLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandlers.add(logoutHandler);
        return this;
    }

    public LogoutConfigurer<H> invalidateHttpSession(boolean invalidateHttpSession) {
        this.contextLogoutHandler.setInvalidateHttpSession(invalidateHttpSession);
        return this;
    }

    public LogoutConfigurer<H> logoutUrl(String logoutUrl) {
        return this.logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(logoutUrl, "POST"));
    }

    public LogoutConfigurer<H> logoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        this.logoutRequestMatcher = logoutRequestMatcher;
        return this;
    }

    public LogoutConfigurer<H> logoutSuccessUrl(String logoutSuccessUrl) {
        this.customLogoutSuccess = true;
        this.logoutSuccessUrl = logoutSuccessUrl;
        return this;
    }

    public LogoutConfigurer<H> permitAll() {
        return this.permitAll(true);
    }

    public LogoutConfigurer<H> deleteCookies(String ... cookieNamesToClear) {
        return this.addLogoutHandler((LogoutHandler)new CookieClearingLogoutHandler(cookieNamesToClear));
    }

    public LogoutConfigurer<H> logoutSuccessHandler(LogoutSuccessHandler logoutSuccessHandler) {
        this.logoutSuccessUrl = null;
        this.customLogoutSuccess = true;
        this.logoutSuccessHandler = logoutSuccessHandler;
        return this;
    }

    public LogoutConfigurer<H> permitAll(boolean permitAll) {
        this.permitAll = permitAll;
        return this;
    }

    private LogoutSuccessHandler getLogoutSuccessHandler() {
        if (this.logoutSuccessHandler != null) {
            return this.logoutSuccessHandler;
        }
        SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        logoutSuccessHandler.setDefaultTargetUrl(this.logoutSuccessUrl);
        return logoutSuccessHandler;
    }

    @Override
    public void init(H http) throws Exception {
        DefaultLoginPageViewFilter loginPageGeneratingFilter;
        if (this.permitAll) {
            PermitAllSupport.permitAll(http, new String[]{this.logoutSuccessUrl});
            PermitAllSupport.permitAll(http, new RequestMatcher[]{this.logoutRequestMatcher});
        }
        if ((loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageViewFilter.class)) != null && !this.isCustomLogoutSuccess()) {
            loginPageGeneratingFilter.setLogoutSuccessUrl(this.getLogoutSuccessUrl());
        }
    }

    @Override
    public void configure(H http) throws Exception {
        LogoutFilter logoutFilter = this.createLogoutFilter();
        http.addFilter((Filter)logoutFilter);
    }

    boolean isCustomLogoutSuccess() {
        return this.customLogoutSuccess;
    }

    private String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    List<LogoutHandler> getLogoutHandlers() {
        return this.logoutHandlers;
    }

    private LogoutFilter createLogoutFilter() throws Exception {
        this.logoutHandlers.add((LogoutHandler)this.contextLogoutHandler);
        LogoutHandler[] handlers = this.logoutHandlers.toArray(new LogoutHandler[this.logoutHandlers.size()]);
        LogoutFilter result = new LogoutFilter(this.getLogoutSuccessHandler(), handlers);
        result.setLogoutRequestMatcher(this.logoutRequestMatcher);
        result = this.postProcess(result);
        return result;
    }
}

