/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.AuthorizationCodeAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.AuthorizationCodeRequestRedirectFilterConfigurer;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.AuthorizationGrantTokenExchanger;
import org.springframework.security.oauth2.client.authentication.AuthorizationRequestUriBuilder;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.user.OAuth2UserService;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2LoginConfigurer<B>, B> {
    private final AuthorizationCodeRequestRedirectFilterConfigurer<B> authorizationCodeRequestRedirectFilterConfigurer = new AuthorizationCodeRequestRedirectFilterConfigurer();
    private final AuthorizationCodeAuthenticationFilterConfigurer<B> authorizationCodeAuthenticationFilterConfigurer = new AuthorizationCodeAuthenticationFilterConfigurer();
    private final UserInfoEndpointConfig userInfoEndpointConfig = new UserInfoEndpointConfig();

    public OAuth2LoginConfigurer<B> clients(ClientRegistration ... clientRegistrations) {
        Assert.notEmpty((Object[])clientRegistrations, (String)"clientRegistrations cannot be empty");
        return this.clients((ClientRegistrationRepository)new InMemoryClientRegistrationRepository(Arrays.asList(clientRegistrations)));
    }

    public OAuth2LoginConfigurer<B> clients(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notEmpty((Collection)clientRegistrationRepository.getRegistrations(), (String)"clientRegistrationRepository cannot be empty");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    public OAuth2LoginConfigurer<B> authorizationRequestBuilder(AuthorizationRequestUriBuilder authorizationRequestBuilder) {
        Assert.notNull((Object)authorizationRequestBuilder, (String)"authorizationRequestBuilder cannot be null");
        this.authorizationCodeRequestRedirectFilterConfigurer.authorizationRequestBuilder(authorizationRequestBuilder);
        return this;
    }

    public OAuth2LoginConfigurer<B> authorizationCodeTokenExchanger(AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger) {
        Assert.notNull(authorizationCodeTokenExchanger, (String)"authorizationCodeTokenExchanger cannot be null");
        this.authorizationCodeAuthenticationFilterConfigurer.authorizationCodeTokenExchanger(authorizationCodeTokenExchanger);
        return this;
    }

    public UserInfoEndpointConfig userInfoEndpoint() {
        return this.userInfoEndpointConfig;
    }

    @Override
    public void init(B http) throws Exception {
        this.authorizationCodeRequestRedirectFilterConfigurer.setBuilder(http);
        this.authorizationCodeAuthenticationFilterConfigurer.setBuilder(http);
        this.authorizationCodeRequestRedirectFilterConfigurer.init(http);
        this.authorizationCodeAuthenticationFilterConfigurer.init(http);
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(B http) throws Exception {
        this.authorizationCodeRequestRedirectFilterConfigurer.configure(http);
        this.authorizationCodeAuthenticationFilterConfigurer.configure(http);
    }

    static <B extends HttpSecurityBuilder<B>> ClientRegistrationRepository getClientRegistrationRepository(B http) {
        ClientRegistrationRepository clientRegistrationRepository = http.getSharedObject(ClientRegistrationRepository.class);
        if (clientRegistrationRepository == null) {
            clientRegistrationRepository = OAuth2LoginConfigurer.getDefaultClientRegistrationRepository(http);
            http.setSharedObject(ClientRegistrationRepository.class, (ClientRegistrationRepository)clientRegistrationRepository);
        }
        return clientRegistrationRepository;
    }

    private static <B extends HttpSecurityBuilder<B>> ClientRegistrationRepository getDefaultClientRegistrationRepository(B http) {
        return (ClientRegistrationRepository)http.getSharedObject(ApplicationContext.class).getBean(ClientRegistrationRepository.class);
    }

    private void initDefaultLoginFilter(B http) {
        ClientRegistrationRepository clientRegistrationRepository;
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter != null && !this.authorizationCodeAuthenticationFilterConfigurer.isCustomLoginPage() && !CollectionUtils.isEmpty((Collection)(clientRegistrationRepository = OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder())).getRegistrations())) {
            Map<String, String> oauth2AuthenticationUrlToClientName = clientRegistrationRepository.getRegistrations().stream().collect(Collectors.toMap(e -> "/oauth2/authorization/code/" + e.getClientAlias(), e -> e.getClientName()));
            loginPageGeneratingFilter.setOauth2LoginEnabled(true);
            loginPageGeneratingFilter.setOauth2AuthenticationUrlToClientName(oauth2AuthenticationUrlToClientName);
            loginPageGeneratingFilter.setLoginPageUrl(this.authorizationCodeAuthenticationFilterConfigurer.getLoginUrl());
            loginPageGeneratingFilter.setFailureUrl(this.authorizationCodeAuthenticationFilterConfigurer.getLoginFailureUrl());
        }
    }

    public class UserInfoEndpointConfig {
        private UserInfoEndpointConfig() {
        }

        public OAuth2LoginConfigurer<B> userInfoService(OAuth2UserService userInfoService) {
            Assert.notNull((Object)userInfoService, (String)"userInfoService cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.userInfoService(userInfoService);
            return this.and();
        }

        public OAuth2LoginConfigurer<B> userInfoTypeConverter(Function<ClientHttpResponse, ? extends OAuth2User> userInfoConverter, URI userInfoUri) {
            Assert.notNull(userInfoConverter, (String)"userInfoConverter cannot be null");
            Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.userInfoTypeConverter(userInfoConverter, userInfoUri);
            return this.and();
        }

        public OAuth2LoginConfigurer<B> and() {
            return OAuth2LoginConfigurer.this;
        }
    }
}

