/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.server.header.CacheControlHttpHeadersWriter;
import org.springframework.security.web.server.header.CompositeHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentTypeOptionsHttpHeadersWriter;
import org.springframework.security.web.server.header.HttpHeaderWriterWebFilter;
import org.springframework.security.web.server.header.HttpHeadersWriter;
import org.springframework.security.web.server.header.StrictTransportSecurityHttpHeadersWriter;
import org.springframework.security.web.server.header.XFrameOptionsHttpHeadersWriter;
import org.springframework.security.web.server.header.XXssProtectionHttpHeadersWriter;

public class HeaderBuilder {
    private final List<HttpHeadersWriter> writers;
    private CacheControlHttpHeadersWriter cacheControl = new CacheControlHttpHeadersWriter();
    private ContentTypeOptionsHttpHeadersWriter contentTypeOptions = new ContentTypeOptionsHttpHeadersWriter();
    private StrictTransportSecurityHttpHeadersWriter hsts = new StrictTransportSecurityHttpHeadersWriter();
    private XFrameOptionsHttpHeadersWriter frameOptions = new XFrameOptionsHttpHeadersWriter();
    private XXssProtectionHttpHeadersWriter xss = new XXssProtectionHttpHeadersWriter();

    public HeaderBuilder() {
        this.writers = new ArrayList<HttpHeadersWriter>(Arrays.asList(this.cacheControl, this.contentTypeOptions, this.hsts, this.frameOptions, this.xss));
    }

    public CacheSpec cache() {
        return new CacheSpec();
    }

    public ContentTypeOptionsSpec contentTypeOptions() {
        return new ContentTypeOptionsSpec();
    }

    public FrameOptionsSpec frameOptions() {
        return new FrameOptionsSpec();
    }

    public HstsSpec hsts() {
        return new HstsSpec();
    }

    public HttpHeaderWriterWebFilter build() {
        CompositeHttpHeadersWriter writer = new CompositeHttpHeadersWriter(this.writers);
        return new HttpHeaderWriterWebFilter((HttpHeadersWriter)writer);
    }

    public XssProtectionSpec xssProtection() {
        return new XssProtectionSpec();
    }

    public class XssProtectionSpec {
        public void disable() {
            HeaderBuilder.this.writers.remove(HeaderBuilder.this.xss);
        }

        private XssProtectionSpec() {
        }
    }

    public class HstsSpec {
        public void maxAge(Duration maxAge) {
            HeaderBuilder.this.hsts.setMaxAge(maxAge);
        }

        public void includeSubdomains(boolean includeSubDomains) {
            HeaderBuilder.this.hsts.setIncludeSubDomains(includeSubDomains);
        }

        public void disable() {
            HeaderBuilder.this.writers.remove(HeaderBuilder.this.hsts);
        }

        private HstsSpec() {
        }
    }

    public class FrameOptionsSpec {
        public void mode(XFrameOptionsHttpHeadersWriter.Mode mode) {
            HeaderBuilder.this.frameOptions.setMode(mode);
        }

        public void disable() {
            HeaderBuilder.this.writers.remove(HeaderBuilder.this.frameOptions);
        }

        private FrameOptionsSpec() {
        }
    }

    public class ContentTypeOptionsSpec {
        public void disable() {
            HeaderBuilder.this.writers.remove(HeaderBuilder.this.contentTypeOptions);
        }

        private ContentTypeOptionsSpec() {
        }
    }

    public class CacheSpec {
        public void disable() {
            HeaderBuilder.this.writers.remove(HeaderBuilder.this.cacheControl);
        }

        private CacheSpec() {
        }
    }
}

