/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.util.Collection;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthorizationCodeRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.AuthorizationRequestUriBuilder;
import org.springframework.security.oauth2.client.web.DefaultAuthorizationRequestUriBuilder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestVariablesExtractor;
import org.springframework.util.Assert;

final class AuthorizationCodeRequestRedirectFilterConfigurer<H extends HttpSecurityBuilder<H>, R extends RequestMatcher & RequestVariablesExtractor>
extends AbstractHttpConfigurer<AuthorizationCodeRequestRedirectFilterConfigurer<H, R>, H> {
    private R authorizationRequestMatcher;
    private AuthorizationRequestUriBuilder authorizationRequestBuilder;

    AuthorizationCodeRequestRedirectFilterConfigurer() {
    }

    AuthorizationCodeRequestRedirectFilterConfigurer<H, R> authorizationRequestMatcher(R authorizationRequestMatcher) {
        Assert.notNull(authorizationRequestMatcher, (String)"authorizationRequestMatcher cannot be null");
        this.authorizationRequestMatcher = authorizationRequestMatcher;
        return this;
    }

    AuthorizationCodeRequestRedirectFilterConfigurer<H, R> authorizationRequestBuilder(AuthorizationRequestUriBuilder authorizationRequestBuilder) {
        Assert.notNull((Object)authorizationRequestBuilder, (String)"authorizationRequestBuilder cannot be null");
        this.authorizationRequestBuilder = authorizationRequestBuilder;
        return this;
    }

    AuthorizationCodeRequestRedirectFilterConfigurer<H, R> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notEmpty((Collection)clientRegistrationRepository.getRegistrations(), (String)"clientRegistrationRepository cannot be empty");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    R getAuthorizationRequestMatcher() {
        return this.authorizationRequestMatcher;
    }

    @Override
    public void configure(H http) throws Exception {
        AuthorizationCodeRequestRedirectFilter filter = new AuthorizationCodeRequestRedirectFilter(OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()), this.getAuthorizationRequestBuilder());
        if (this.authorizationRequestMatcher != null) {
            filter.setAuthorizationRequestMatcher(this.authorizationRequestMatcher);
        }
        http.addFilter((Filter)this.postProcess(filter));
    }

    private AuthorizationRequestUriBuilder getAuthorizationRequestBuilder() {
        if (this.authorizationRequestBuilder == null) {
            this.authorizationRequestBuilder = new DefaultAuthorizationRequestUriBuilder();
        }
        return this.authorizationRequestBuilder;
    }
}

