/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.authentication.www.DigestAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.web.filter.CorsFilter;

final class FilterComparator
implements Comparator<Filter>,
Serializable {
    private static final int STEP = 100;
    private Map<String, Integer> filterToOrder = new HashMap<String, Integer>();

    FilterComparator() {
        int order = 100;
        this.put(ChannelProcessingFilter.class, order);
        this.put(ConcurrentSessionFilter.class, order += 100);
        this.put(WebAsyncManagerIntegrationFilter.class, order += 100);
        this.put(SecurityContextPersistenceFilter.class, order += 100);
        this.put(HeaderWriterFilter.class, order += 100);
        this.put(CorsFilter.class, order += 100);
        this.put(CsrfFilter.class, order += 100);
        this.put(LogoutFilter.class, order += 100);
        this.filterToOrder.put("org.springframework.security.oauth2.client.web.AuthorizationCodeRequestRedirectFilter", order += 100);
        this.put(X509AuthenticationFilter.class, order += 100);
        this.put(AbstractPreAuthenticatedProcessingFilter.class, order += 100);
        this.filterToOrder.put("org.springframework.security.cas.web.CasAuthenticationFilter", order += 100);
        this.filterToOrder.put("org.springframework.security.oauth2.client.web.AuthorizationCodeAuthenticationFilter", order += 100);
        this.put(UsernamePasswordAuthenticationFilter.class, order += 100);
        this.put(ConcurrentSessionFilter.class, order += 100);
        this.filterToOrder.put("org.springframework.security.openid.OpenIDAuthenticationFilter", order += 100);
        this.put(DefaultLoginPageGeneratingFilter.class, order += 100);
        this.put(ConcurrentSessionFilter.class, order += 100);
        this.put(DigestAuthenticationFilter.class, order += 100);
        this.put(BasicAuthenticationFilter.class, order += 100);
        this.put(RequestCacheAwareFilter.class, order += 100);
        this.put(SecurityContextHolderAwareRequestFilter.class, order += 100);
        this.put(JaasApiIntegrationFilter.class, order += 100);
        this.put(RememberMeAuthenticationFilter.class, order += 100);
        this.put(AnonymousAuthenticationFilter.class, order += 100);
        this.put(SessionManagementFilter.class, order += 100);
        this.put(ExceptionTranslationFilter.class, order += 100);
        this.put(FilterSecurityInterceptor.class, order += 100);
        this.put(SwitchUserFilter.class, order += 100);
    }

    @Override
    public int compare(Filter lhs, Filter rhs) {
        Integer left = this.getOrder(lhs.getClass());
        Integer right = this.getOrder(rhs.getClass());
        return left - right;
    }

    public boolean isRegistered(Class<? extends Filter> filter) {
        return this.getOrder(filter) != null;
    }

    public void registerAfter(Class<? extends Filter> filter, Class<? extends Filter> afterFilter) {
        Integer position = this.getOrder(afterFilter);
        if (position == null) {
            throw new IllegalArgumentException("Cannot register after unregistered Filter " + afterFilter);
        }
        this.put(filter, position + 1);
    }

    public void registerAt(Class<? extends Filter> filter, Class<? extends Filter> atFilter) {
        Integer position = this.getOrder(atFilter);
        if (position == null) {
            throw new IllegalArgumentException("Cannot register after unregistered Filter " + atFilter);
        }
        this.put(filter, position);
    }

    public void registerBefore(Class<? extends Filter> filter, Class<? extends Filter> beforeFilter) {
        Integer position = this.getOrder(beforeFilter);
        if (position == null) {
            throw new IllegalArgumentException("Cannot register after unregistered Filter " + beforeFilter);
        }
        this.put(filter, position - 1);
    }

    private void put(Class<? extends Filter> filter, int position) {
        String className = filter.getName();
        this.filterToOrder.put(className, position);
    }

    private Integer getOrder(Class<?> clazz) {
        while (clazz != null) {
            Integer result = this.filterToOrder.get(clazz.getName());
            if (result != null) {
                return result;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

