/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticator;
import org.springframework.security.oauth2.client.authentication.AuthorizationGrantAuthenticator;
import org.springframework.security.oauth2.client.authentication.DelegatingAuthorizationGrantAuthenticator;
import org.springframework.security.oauth2.client.authentication.OAuth2UserAuthenticationProvider;
import org.springframework.security.oauth2.client.authentication.jwt.JwtDecoderRegistry;
import org.springframework.security.oauth2.client.authentication.jwt.nimbus.NimbusJwtDecoderRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.token.SecurityTokenRepository;
import org.springframework.security.oauth2.client.user.CustomUserTypesOAuth2UserService;
import org.springframework.security.oauth2.client.user.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.user.DelegatingOAuth2UserService;
import org.springframework.security.oauth2.client.user.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationCodeAuthenticationFilter;
import org.springframework.security.oauth2.client.web.AuthorizationGrantTokenExchanger;
import org.springframework.security.oauth2.client.web.nimbus.NimbusAuthorizationCodeTokenExchanger;
import org.springframework.security.oauth2.core.AccessToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.oidc.client.authentication.OidcAuthorizationCodeAuthenticator;
import org.springframework.security.oauth2.oidc.client.user.OidcUserService;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class AuthorizationCodeAuthenticationFilterConfigurer<H extends HttpSecurityBuilder<H>, R extends RequestMatcher>
extends AbstractAuthenticationFilterConfigurer<H, AuthorizationCodeAuthenticationFilterConfigurer<H, R>, AuthorizationCodeAuthenticationFilter> {
    private R authorizationResponseMatcher;
    private AuthorizationGrantAuthenticator<AuthorizationCodeAuthenticationToken> authorizationCodeAuthenticator;
    private AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger;
    private SecurityTokenRepository<AccessToken> accessTokenRepository;
    private JwtDecoderRegistry jwtDecoderRegistry;
    private OAuth2UserService userInfoService;
    private Map<URI, Class<? extends OAuth2User>> customUserTypes = new HashMap<URI, Class<? extends OAuth2User>>();
    private GrantedAuthoritiesMapper userAuthoritiesMapper;

    AuthorizationCodeAuthenticationFilterConfigurer() {
        super(new AuthorizationCodeAuthenticationFilter(), null);
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> authorizationResponseMatcher(R authorizationResponseMatcher) {
        Assert.notNull(authorizationResponseMatcher, (String)"authorizationResponseMatcher cannot be null");
        this.authorizationResponseMatcher = authorizationResponseMatcher;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> authorizationCodeTokenExchanger(AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger) {
        Assert.notNull(authorizationCodeTokenExchanger, (String)"authorizationCodeTokenExchanger cannot be null");
        this.authorizationCodeTokenExchanger = authorizationCodeTokenExchanger;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> accessTokenRepository(SecurityTokenRepository<AccessToken> accessTokenRepository) {
        Assert.notNull(accessTokenRepository, (String)"accessTokenRepository cannot be null");
        this.accessTokenRepository = accessTokenRepository;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> jwtDecoderRegistry(JwtDecoderRegistry jwtDecoderRegistry) {
        Assert.notNull((Object)jwtDecoderRegistry, (String)"jwtDecoderRegistry cannot be null");
        this.jwtDecoderRegistry = jwtDecoderRegistry;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> userInfoService(OAuth2UserService userInfoService) {
        Assert.notNull((Object)userInfoService, (String)"userInfoService cannot be null");
        this.userInfoService = userInfoService;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> customUserType(Class<? extends OAuth2User> customUserType, URI userInfoUri) {
        Assert.notNull(customUserType, (String)"customUserType cannot be null");
        Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
        this.customUserTypes.put(userInfoUri, customUserType);
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> userAuthoritiesMapper(GrantedAuthoritiesMapper userAuthoritiesMapper) {
        Assert.notNull((Object)userAuthoritiesMapper, (String)"userAuthoritiesMapper cannot be null");
        this.userAuthoritiesMapper = userAuthoritiesMapper;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    String getLoginUrl() {
        return super.getLoginPage();
    }

    String getLoginFailureUrl() {
        return super.getFailureUrl();
    }

    @Override
    public void init(H http) throws Exception {
        AuthorizationCodeAuthenticationProvider authorizationCodeAuthenticationProvider = new AuthorizationCodeAuthenticationProvider(this.getAuthorizationCodeAuthenticator());
        if (this.accessTokenRepository != null) {
            authorizationCodeAuthenticationProvider.setAccessTokenRepository(this.accessTokenRepository);
        }
        authorizationCodeAuthenticationProvider = this.postProcess(authorizationCodeAuthenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authorizationCodeAuthenticationProvider);
        OAuth2UserAuthenticationProvider oauth2UserAuthenticationProvider = new OAuth2UserAuthenticationProvider(this.getUserInfoService());
        if (this.userAuthoritiesMapper != null) {
            oauth2UserAuthenticationProvider.setAuthoritiesMapper(this.userAuthoritiesMapper);
        }
        oauth2UserAuthenticationProvider = this.postProcess(oauth2UserAuthenticationProvider);
        http.authenticationProvider((AuthenticationProvider)oauth2UserAuthenticationProvider);
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        AuthorizationCodeAuthenticationFilter authFilter = (AuthorizationCodeAuthenticationFilter)this.getAuthenticationFilter();
        if (this.authorizationResponseMatcher != null) {
            authFilter.setAuthorizationResponseMatcher(this.authorizationResponseMatcher);
        }
        authFilter.setClientRegistrationRepository(OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()));
        super.configure(http);
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return this.authorizationResponseMatcher != null ? this.authorizationResponseMatcher : ((AuthorizationCodeAuthenticationFilter)this.getAuthenticationFilter()).getAuthorizationResponseMatcher();
    }

    private AuthorizationGrantAuthenticator<AuthorizationCodeAuthenticationToken> getAuthorizationCodeAuthenticator() {
        if (this.authorizationCodeAuthenticator == null) {
            ArrayList<Object> authenticators = new ArrayList<Object>();
            authenticators.add(new AuthorizationCodeAuthenticator(this.getAuthorizationCodeTokenExchanger()));
            authenticators.add(new OidcAuthorizationCodeAuthenticator(this.getAuthorizationCodeTokenExchanger(), this.getJwtDecoderRegistry()));
            this.authorizationCodeAuthenticator = new DelegatingAuthorizationGrantAuthenticator(authenticators);
        }
        return this.authorizationCodeAuthenticator;
    }

    private AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> getAuthorizationCodeTokenExchanger() {
        if (this.authorizationCodeTokenExchanger == null) {
            this.authorizationCodeTokenExchanger = new NimbusAuthorizationCodeTokenExchanger();
        }
        return this.authorizationCodeTokenExchanger;
    }

    private JwtDecoderRegistry getJwtDecoderRegistry() {
        if (this.jwtDecoderRegistry == null) {
            this.jwtDecoderRegistry = new NimbusJwtDecoderRegistry();
        }
        return this.jwtDecoderRegistry;
    }

    private OAuth2UserService getUserInfoService() {
        if (this.userInfoService == null) {
            ArrayList<Object> oauth2UserServices = new ArrayList<Object>();
            oauth2UserServices.add(new DefaultOAuth2UserService());
            oauth2UserServices.add(new OidcUserService());
            if (!this.customUserTypes.isEmpty()) {
                oauth2UserServices.add(new CustomUserTypesOAuth2UserService(this.customUserTypes));
            }
            this.userInfoService = new DelegatingOAuth2UserService(oauth2UserServices);
        }
        return this.userInfoService;
    }
}

