/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.web.server.AbstractServerWebExchangeMatcherRegistry;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.web.server.AuthenticationEntryPoint;
import org.springframework.security.web.server.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.server.FormLoginAuthenticationConverter;
import org.springframework.security.web.server.HttpBasicAuthenticationConverter;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.RedirectAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.LogoutHandler;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.SecurityContextRepositoryLogoutHandler;
import org.springframework.security.web.server.authentication.www.HttpBasicAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.authorization.AuthorizationWebFilter;
import org.springframework.security.web.server.authorization.DelegatingReactiveAuthorizationManager;
import org.springframework.security.web.server.authorization.ExceptionTranslationWebFilter;
import org.springframework.security.web.server.context.AuthenticationReactorContextFilter;
import org.springframework.security.web.server.context.SecurityContextRepository;
import org.springframework.security.web.server.context.SecurityContextRepositoryWebFilter;
import org.springframework.security.web.server.context.ServerWebExchangeAttributeSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionSecurityContextRepository;
import org.springframework.security.web.server.header.CacheControlHttpHeadersWriter;
import org.springframework.security.web.server.header.CompositeHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentTypeOptionsHttpHeadersWriter;
import org.springframework.security.web.server.header.HttpHeaderWriterWebFilter;
import org.springframework.security.web.server.header.HttpHeadersWriter;
import org.springframework.security.web.server.header.StrictTransportSecurityHttpHeadersWriter;
import org.springframework.security.web.server.header.XFrameOptionsHttpHeadersWriter;
import org.springframework.security.web.server.header.XXssProtectionHttpHeadersWriter;
import org.springframework.security.web.server.ui.LoginPageGeneratingWebFilter;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcherEntry;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class HttpSecurity {
    private ServerWebExchangeMatcher securityMatcher = ServerWebExchangeMatchers.anyExchange();
    private AuthorizeExchangeBuilder authorizeExchangeBuilder;
    private HeaderBuilder headers;
    private HttpBasicBuilder httpBasic;
    private FormLoginBuilder formLogin;
    private LogoutBuilder logout;
    private ReactiveAuthenticationManager authenticationManager;
    private SecurityContextRepository securityContextRepository;
    private AuthenticationEntryPoint authenticationEntryPoint;
    private List<DelegatingAuthenticationEntryPoint.DelegateEntry> defaultEntryPoints = new ArrayList<DelegatingAuthenticationEntryPoint.DelegateEntry>();
    private List<WebFilter> webFilters = new ArrayList<WebFilter>();

    public HttpSecurity securityMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"matcher cannot be null");
        this.securityMatcher = matcher;
        return this;
    }

    public HttpSecurity addFilterAt(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder()));
        return this;
    }

    private ServerWebExchangeMatcher getSecurityMatcher() {
        return this.securityMatcher;
    }

    public HttpSecurity securityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
        return this;
    }

    public HttpBasicBuilder httpBasic() {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicBuilder();
        }
        return this.httpBasic;
    }

    public FormLoginBuilder formLogin() {
        if (this.formLogin == null) {
            this.formLogin = new FormLoginBuilder();
        }
        return this.formLogin;
    }

    public HeaderBuilder headers() {
        if (this.headers == null) {
            this.headers = new HeaderBuilder();
        }
        return this.headers;
    }

    public AuthorizeExchangeBuilder authorizeExchange() {
        if (this.authorizeExchangeBuilder == null) {
            this.authorizeExchangeBuilder = new AuthorizeExchangeBuilder();
        }
        return this.authorizeExchangeBuilder;
    }

    public LogoutBuilder logout() {
        if (this.logout == null) {
            this.logout = new LogoutBuilder();
        }
        return this.logout;
    }

    public HttpSecurity authenticationManager(ReactiveAuthenticationManager manager) {
        this.authenticationManager = manager;
        return this;
    }

    public SecurityWebFilterChain build() {
        WebFilter securityContextRepositoryWebFilter;
        if (this.headers != null) {
            this.headers.configure(this);
        }
        if ((securityContextRepositoryWebFilter = this.securityContextRepositoryWebFilter()) != null) {
            this.webFilters.add(securityContextRepositoryWebFilter);
        }
        if (this.httpBasic != null) {
            this.httpBasic.authenticationManager(this.authenticationManager);
            if (this.securityContextRepository != null) {
                this.httpBasic.securityContextRepository(this.securityContextRepository);
            }
            this.httpBasic.configure(this);
        }
        if (this.formLogin != null) {
            this.formLogin.authenticationManager(this.authenticationManager);
            if (this.securityContextRepository != null) {
                this.formLogin.securityContextRepository(this.securityContextRepository);
            }
            if (this.formLogin.authenticationEntryPoint == null) {
                this.webFilters.add(new OrderedWebFilter((WebFilter)new LoginPageGeneratingWebFilter(), SecurityWebFiltersOrder.LOGIN_PAGE_GENERATING.getOrder()));
            }
            this.formLogin.configure(this);
        }
        if (this.logout != null) {
            this.logout.configure(this);
        }
        this.addFilterAt((WebFilter)new AuthenticationReactorContextFilter(), SecurityWebFiltersOrder.AUTHENTICATION_CONTEXT);
        if (this.authorizeExchangeBuilder != null) {
            AuthenticationEntryPoint authenticationEntryPoint = this.getAuthenticationEntryPoint();
            ExceptionTranslationWebFilter exceptionTranslationWebFilter = new ExceptionTranslationWebFilter();
            if (authenticationEntryPoint != null) {
                exceptionTranslationWebFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
            }
            this.addFilterAt((WebFilter)exceptionTranslationWebFilter, SecurityWebFiltersOrder.EXCEPTION_TRANSLATION);
            this.authorizeExchangeBuilder.configure(this);
        }
        AnnotationAwareOrderComparator.sort(this.webFilters);
        return new MatcherSecurityWebFilterChain(this.getSecurityMatcher(), this.webFilters);
    }

    private AuthenticationEntryPoint getAuthenticationEntryPoint() {
        if (this.authenticationEntryPoint != null || this.defaultEntryPoints.isEmpty()) {
            return this.authenticationEntryPoint;
        }
        if (this.defaultEntryPoints.size() == 1) {
            return this.defaultEntryPoints.get(0).getEntryPoint();
        }
        DelegatingAuthenticationEntryPoint result = new DelegatingAuthenticationEntryPoint(this.defaultEntryPoints);
        result.setDefaultEntryPoint(this.defaultEntryPoints.get(this.defaultEntryPoints.size() - 1).getEntryPoint());
        return result;
    }

    public static HttpSecurity http() {
        return new HttpSecurity();
    }

    private WebFilter securityContextRepositoryWebFilter() {
        SecurityContextRepository repository = this.securityContextRepository;
        if (repository == null) {
            return null;
        }
        SecurityContextRepositoryWebFilter result = new SecurityContextRepositoryWebFilter(repository);
        return new OrderedWebFilter((WebFilter)result, SecurityWebFiltersOrder.SECURITY_CONTEXT_REPOSITORY.getOrder());
    }

    private HttpSecurity() {
    }

    private static class OrderedWebFilter
    implements WebFilter,
    Ordered {
        private final WebFilter webFilter;
        private final int order;

        public OrderedWebFilter(WebFilter webFilter, int order) {
            this.webFilter = webFilter;
            this.order = order;
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            return this.webFilter.filter(exchange, chain);
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedWebFilter{webFilter=" + this.webFilter + ", order=" + this.order + '}';
        }
    }

    public final class LogoutBuilder {
        private LogoutHandler logoutHandler = new SecurityContextRepositoryLogoutHandler();
        private String logoutUrl = "/logout";
        private ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{this.logoutUrl});

        public LogoutBuilder logoutHandler(LogoutHandler logoutHandler) {
            Assert.notNull((Object)logoutHandler, (String)"logoutHandler must not be null");
            this.logoutHandler = logoutHandler;
            return this;
        }

        public LogoutBuilder logoutUrl(String logoutUrl) {
            Assert.notNull((Object)this.logoutHandler, (String)"logoutUrl must not be null");
            this.logoutUrl = logoutUrl;
            this.requiresLogout = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{logoutUrl});
            return this;
        }

        public HttpSecurity disable() {
            HttpSecurity.this.logout = null;
            return this.and();
        }

        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        public void configure(HttpSecurity http) {
            LogoutWebFilter logoutWebFilter = this.createLogoutWebFilter(http);
            http.addFilterAt((WebFilter)logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
        }

        private LogoutWebFilter createLogoutWebFilter(HttpSecurity http) {
            LogoutWebFilter logoutWebFilter = new LogoutWebFilter();
            logoutWebFilter.setLogoutHandler(this.logoutHandler);
            logoutWebFilter.setRequiresLogout(this.requiresLogout);
            return logoutWebFilter;
        }

        private LogoutBuilder() {
        }
    }

    public class HeaderBuilder {
        private final List<HttpHeadersWriter> writers;
        private CacheControlHttpHeadersWriter cacheControl = new CacheControlHttpHeadersWriter();
        private ContentTypeOptionsHttpHeadersWriter contentTypeOptions = new ContentTypeOptionsHttpHeadersWriter();
        private StrictTransportSecurityHttpHeadersWriter hsts = new StrictTransportSecurityHttpHeadersWriter();
        private XFrameOptionsHttpHeadersWriter frameOptions = new XFrameOptionsHttpHeadersWriter();
        private XXssProtectionHttpHeadersWriter xss = new XXssProtectionHttpHeadersWriter();

        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        public CacheSpec cache() {
            return new CacheSpec();
        }

        public ContentTypeOptionsSpec contentTypeOptions() {
            return new ContentTypeOptionsSpec();
        }

        public FrameOptionsSpec frameOptions() {
            return new FrameOptionsSpec();
        }

        public HstsSpec hsts() {
            return new HstsSpec();
        }

        protected void configure(HttpSecurity http) {
            CompositeHttpHeadersWriter writer = new CompositeHttpHeadersWriter(this.writers);
            HttpHeaderWriterWebFilter result = new HttpHeaderWriterWebFilter((HttpHeadersWriter)writer);
            http.addFilterAt((WebFilter)result, SecurityWebFiltersOrder.HTTP_HEADERS_WRITER);
        }

        public XssProtectionSpec xssProtection() {
            return new XssProtectionSpec();
        }

        private HeaderBuilder() {
            this.writers = new ArrayList<HttpHeadersWriter>(Arrays.asList(this.cacheControl, this.contentTypeOptions, this.hsts, this.frameOptions, this.xss));
        }

        public class XssProtectionSpec {
            public void disable() {
                HeaderBuilder.this.writers.remove(HeaderBuilder.this.xss);
            }

            private XssProtectionSpec() {
            }
        }

        public class HstsSpec {
            public void maxAge(Duration maxAge) {
                HeaderBuilder.this.hsts.setMaxAge(maxAge);
            }

            public void includeSubdomains(boolean includeSubDomains) {
                HeaderBuilder.this.hsts.setIncludeSubDomains(includeSubDomains);
            }

            public void disable() {
                HeaderBuilder.this.writers.remove(HeaderBuilder.this.hsts);
            }

            private HstsSpec() {
            }
        }

        public class FrameOptionsSpec {
            public void mode(XFrameOptionsHttpHeadersWriter.Mode mode) {
                HeaderBuilder.this.frameOptions.setMode(mode);
            }

            public void disable() {
                HeaderBuilder.this.writers.remove(HeaderBuilder.this.frameOptions);
            }

            private FrameOptionsSpec() {
            }
        }

        public class ContentTypeOptionsSpec {
            public void disable() {
                HeaderBuilder.this.writers.remove(HeaderBuilder.this.contentTypeOptions);
            }

            private ContentTypeOptionsSpec() {
            }
        }

        public class CacheSpec {
            public void disable() {
                HeaderBuilder.this.writers.remove(HeaderBuilder.this.cacheControl);
            }

            private CacheSpec() {
            }
        }
    }

    public class FormLoginBuilder {
        private ReactiveAuthenticationManager authenticationManager;
        private SecurityContextRepository securityContextRepository = new WebSessionSecurityContextRepository();
        private AuthenticationEntryPoint authenticationEntryPoint;
        private ServerWebExchangeMatcher requiresAuthenticationMatcher;
        private AuthenticationFailureHandler authenticationFailureHandler;

        public FormLoginBuilder authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public FormLoginBuilder loginPage(String loginPage) {
            this.authenticationEntryPoint = new RedirectAuthenticationEntryPoint(loginPage);
            this.requiresAuthenticationMatcher = ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{loginPage});
            this.authenticationFailureHandler = new AuthenticationEntryPointFailureHandler((AuthenticationEntryPoint)new RedirectAuthenticationEntryPoint(loginPage + "?error"));
            return this;
        }

        public FormLoginBuilder authenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
            this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public FormLoginBuilder requiresAuthenticationMatcher(ServerWebExchangeMatcher requiresAuthenticationMatcher) {
            this.requiresAuthenticationMatcher = requiresAuthenticationMatcher;
            return this;
        }

        public FormLoginBuilder authenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        public FormLoginBuilder securityContextRepository(SecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        public HttpSecurity disable() {
            HttpSecurity.this.formLogin = null;
            return HttpSecurity.this;
        }

        protected void configure(HttpSecurity http) {
            if (this.authenticationEntryPoint == null) {
                this.loginPage("/login");
            }
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.TEXT_HTML});
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            HttpSecurity.this.defaultEntryPoints.add(0, new DelegatingAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)htmlMatcher, this.authenticationEntryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setRequiresAuthenticationMatcher(this.requiresAuthenticationMatcher);
            authenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler);
            authenticationFilter.setAuthenticationConverter((Function)new FormLoginAuthenticationConverter());
            authenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new RedirectAuthenticationSuccessHandler("/"));
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.FORM_LOGIN);
        }

        private FormLoginBuilder() {
        }
    }

    public class HttpBasicBuilder {
        private ReactiveAuthenticationManager authenticationManager;
        private SecurityContextRepository securityContextRepository = new ServerWebExchangeAttributeSecurityContextRepository();
        private AuthenticationEntryPoint entryPoint = new HttpBasicAuthenticationEntryPoint();

        public HttpBasicBuilder authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public HttpBasicBuilder securityContextRepository(SecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        public HttpSecurity disable() {
            HttpSecurity.this.httpBasic = null;
            return HttpSecurity.this;
        }

        protected void configure(HttpSecurity http) {
            MediaTypeServerWebExchangeMatcher restMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
            restMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            HttpSecurity.this.defaultEntryPoints.add(new DelegatingAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)restMatcher, this.entryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new AuthenticationEntryPointFailureHandler(this.entryPoint));
            authenticationFilter.setAuthenticationConverter((Function)new HttpBasicAuthenticationConverter());
            if (this.securityContextRepository != null) {
                authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            }
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        }

        private HttpBasicBuilder() {
        }
    }

    public class AuthorizeExchangeBuilder
    extends AbstractServerWebExchangeMatcherRegistry<Access> {
        private DelegatingReactiveAuthorizationManager.Builder managerBldr = DelegatingReactiveAuthorizationManager.builder();
        private ServerWebExchangeMatcher matcher;
        private boolean anyExchangeRegistered;

        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        @Override
        public Access anyExchange() {
            Access result = (Access)super.anyExchange();
            this.anyExchangeRegistered = true;
            return result;
        }

        @Override
        protected Access registerMatcher(ServerWebExchangeMatcher matcher) {
            if (this.anyExchangeRegistered) {
                throw new IllegalStateException("Cannot register " + matcher + " which would be unreachable because anyExchange() has already been registered.");
            }
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + matcher + " does not have an access rule defined");
            }
            this.matcher = matcher;
            return new Access();
        }

        protected void configure(HttpSecurity http) {
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + this.matcher + " does not have an access rule defined");
            }
            AuthorizationWebFilter result = new AuthorizationWebFilter((ReactiveAuthorizationManager)this.managerBldr.build());
            http.addFilterAt((WebFilter)result, SecurityWebFiltersOrder.AUTHORIZATION);
        }

        public final class Access {
            public AuthorizeExchangeBuilder permitAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(true))));
            }

            public AuthorizeExchangeBuilder denyAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(false))));
            }

            public AuthorizeExchangeBuilder hasRole(String role) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityAuthorizationManager.hasRole((String)role));
            }

            public AuthorizeExchangeBuilder hasAuthority(String authority) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityAuthorizationManager.hasAuthority((String)authority));
            }

            public AuthorizeExchangeBuilder authenticated() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthenticatedAuthorizationManager.authenticated());
            }

            public AuthorizeExchangeBuilder access(ReactiveAuthorizationManager<AuthorizationContext> manager) {
                AuthorizeExchangeBuilder.this.managerBldr.add(new ServerWebExchangeMatcherEntry(AuthorizeExchangeBuilder.this.matcher, manager));
                AuthorizeExchangeBuilder.this.matcher = null;
                return AuthorizeExchangeBuilder.this;
            }
        }
    }
}

