/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.core.userdetails;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.springframework.security.util.InMemoryResource;
import org.springframework.util.Assert;

public class UserDetailsResourceFactoryBean
implements ResourceLoaderAware,
FactoryBean<Collection<UserDetails>> {
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private String resourceLocation;
    private Resource resource;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"resourceLoader cannot be null");
        this.resourceLoader = resourceLoader;
    }

    public Collection<UserDetails> getObject() throws Exception {
        Properties userProperties = new Properties();
        Resource resource = this.getPropertiesResource();
        try (InputStream in = resource.getInputStream();){
            userProperties.load(in);
        }
        ArrayList<UserDetails> users = new ArrayList<UserDetails>(userProperties.size());
        Enumeration<?> names = userProperties.propertyNames();
        UserAttributeEditor editor = new UserAttributeEditor();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String property = userProperties.getProperty(name);
            editor.setAsText(property);
            UserAttribute attr = (UserAttribute)editor.getValue();
            if (attr == null) {
                throw new IllegalStateException("The entry with username '" + name + "' and value '" + property + "' could not be converted to a UserDetails.");
            }
            UserDetails user = User.withUsername((String)name).password(attr.getPassword()).disabled(!attr.isEnabled()).authorities((Collection)attr.getAuthorities()).build();
            users.add(user);
        }
        return users;
    }

    public Class<?> getObjectType() {
        return Collection.class;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    private Resource getPropertiesResource() {
        Resource result = this.resource;
        if (result == null && this.resourceLocation != null) {
            result = this.resourceLoader.getResource(this.resourceLocation);
        }
        Assert.notNull((Object)result, (String)"resource cannot be null if resourceLocation is null");
        return result;
    }

    public static UserDetailsResourceFactoryBean fromResourceLocation(String resourceLocation) {
        UserDetailsResourceFactoryBean result = new UserDetailsResourceFactoryBean();
        result.setResourceLocation(resourceLocation);
        return result;
    }

    public static UserDetailsResourceFactoryBean fromResource(Resource propertiesResource) {
        UserDetailsResourceFactoryBean result = new UserDetailsResourceFactoryBean();
        result.setResource(propertiesResource);
        return result;
    }

    public static UserDetailsResourceFactoryBean fromString(String users) {
        InMemoryResource resource = new InMemoryResource(users);
        return UserDetailsResourceFactoryBean.fromResource((Resource)resource);
    }
}

