/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.method.annotation.OAuth2ClientArgumentResolver;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Import(value={OAuth2ClientWebMvcImportSelector.class})
final class OAuth2ClientConfiguration {
    OAuth2ClientConfiguration() {
    }

    @Configuration
    static class OAuth2ClientWebMvcSecurityConfiguration
    implements WebMvcConfigurer {
        @Autowired(required=false)
        private ClientRegistrationRepository clientRegistrationRepository;
        @Autowired(required=false)
        private OAuth2AuthorizedClientService authorizedClientService;

        OAuth2ClientWebMvcSecurityConfiguration() {
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            if (this.clientRegistrationRepository != null && this.authorizedClientService != null) {
                OAuth2ClientArgumentResolver oauth2ClientArgumentResolver = new OAuth2ClientArgumentResolver(this.clientRegistrationRepository, this.authorizedClientService);
                argumentResolvers.add((HandlerMethodArgumentResolver)oauth2ClientArgumentResolver);
            }
        }
    }

    static class OAuth2ClientWebMvcImportSelector
    implements ImportSelector {
        OAuth2ClientWebMvcImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            boolean webmvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)this.getClass().getClassLoader());
            if (webmvcPresent) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration.OAuth2ClientWebMvcSecurityConfiguration";
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }
}

