/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.result.method.annotation.OAuth2ClientArgumentResolver;
import org.springframework.util.ClassUtils;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

final class ReactiveOAuth2ClientImportSelector
implements ImportSelector {
    ReactiveOAuth2ClientImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        String[] stringArray;
        boolean oauth2ClientPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistration", (ClassLoader)this.getClass().getClassLoader());
        if (oauth2ClientPresent) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.springframework.security.config.annotation.web.reactive.ReactiveOAuth2ClientImportSelector$OAuth2ClientWebFluxSecurityConfiguration";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Configuration
    static class OAuth2ClientWebFluxSecurityConfiguration
    implements WebFluxConfigurer {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ReactiveOAuth2AuthorizedClientService authorizedClientService;

        OAuth2ClientWebFluxSecurityConfiguration() {
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            if (this.clientRegistrationRepository != null && this.authorizedClientService != null) {
                configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{new OAuth2ClientArgumentResolver(this.clientRegistrationRepository, this.authorizedClientService)});
            }
        }

        @Autowired(required=false)
        public void setClientRegistrationRepository(List<ReactiveClientRegistrationRepository> clientRegistrationRepository) {
            if (clientRegistrationRepository.size() == 1) {
                this.clientRegistrationRepository = clientRegistrationRepository.get(0);
            }
        }

        @Autowired(required=false)
        public void setAuthorizedClientService(List<ReactiveOAuth2AuthorizedClientService> authorizedClientService) {
            if (authorizedClientService.size() == 1) {
                this.authorizedClientService = authorizedClientService.get(0);
            }
        }
    }
}

