/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;

public final class OAuth2Configurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2Configurer<B>, B> {
    @Autowired
    private ObjectPostProcessor<Object> objectPostProcessor;
    private OAuth2ClientConfigurer<B> clientConfigurer;
    private OAuth2ResourceServerConfigurer<B> resourceServerConfigurer;

    public OAuth2ClientConfigurer<B> client() {
        if (this.clientConfigurer == null) {
            this.initClientConfigurer();
        }
        return this.clientConfigurer;
    }

    public OAuth2ResourceServerConfigurer<B> resourceServer() {
        if (this.resourceServerConfigurer == null) {
            this.initResourceServerConfigurer();
        }
        return this.resourceServerConfigurer;
    }

    @Override
    public void init(B builder) throws Exception {
        if (this.clientConfigurer != null) {
            this.clientConfigurer.init(builder);
        }
        if (this.resourceServerConfigurer != null) {
            this.resourceServerConfigurer.init(builder);
        }
    }

    @Override
    public void configure(B builder) throws Exception {
        if (this.clientConfigurer != null) {
            this.clientConfigurer.configure(builder);
        }
        if (this.resourceServerConfigurer != null) {
            this.resourceServerConfigurer.configure(builder);
        }
    }

    private void initClientConfigurer() {
        this.clientConfigurer = new OAuth2ClientConfigurer();
        this.clientConfigurer.setBuilder(this.getBuilder());
        this.clientConfigurer.addObjectPostProcessor(this.objectPostProcessor);
    }

    private void initResourceServerConfigurer() {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        this.resourceServerConfigurer = new OAuth2ResourceServerConfigurer(context);
        this.resourceServerConfigurer.setBuilder((B)((HttpSecurityBuilder)this.getBuilder()));
        this.resourceServerConfigurer.addObjectPostProcessor(this.objectPostProcessor);
    }
}

