/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurerUtils;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.endpoint.NimbusAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationCodeGrantFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.util.Assert;

public final class OAuth2ClientConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2ClientConfigurer<B>, B> {
    private AuthorizationCodeGrantConfigurer authorizationCodeGrantConfigurer;

    public OAuth2ClientConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    public OAuth2ClientConfigurer<B> authorizedClientRepository(OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizedClientRepository.class, authorizedClientRepository);
        return this;
    }

    public OAuth2ClientConfigurer<B> authorizedClientService(OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, (String)"authorizedClientService cannot be null");
        this.authorizedClientRepository((OAuth2AuthorizedClientRepository)new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService));
        return this;
    }

    public AuthorizationCodeGrantConfigurer authorizationCodeGrant() {
        if (this.authorizationCodeGrantConfigurer == null) {
            this.authorizationCodeGrantConfigurer = new AuthorizationCodeGrantConfigurer();
        }
        return this.authorizationCodeGrantConfigurer;
    }

    @Override
    public void init(B builder) throws Exception {
        if (this.authorizationCodeGrantConfigurer != null) {
            this.init(builder, this.authorizationCodeGrantConfigurer);
        }
    }

    @Override
    public void configure(B builder) throws Exception {
        if (this.authorizationCodeGrantConfigurer != null) {
            this.configure(builder, this.authorizationCodeGrantConfigurer);
        }
    }

    private void init(B builder, AuthorizationCodeGrantConfigurer authorizationCodeGrantConfigurer) throws Exception {
        OAuth2AccessTokenResponseClient accessTokenResponseClient = ((AuthorizationCodeGrantConfigurer.TokenEndpointConfig)authorizationCodeGrantConfigurer.tokenEndpointConfig).accessTokenResponseClient;
        if (accessTokenResponseClient == null) {
            accessTokenResponseClient = new NimbusAuthorizationCodeTokenResponseClient();
        }
        OAuth2AuthorizationCodeAuthenticationProvider authorizationCodeAuthenticationProvider = new OAuth2AuthorizationCodeAuthenticationProvider(accessTokenResponseClient);
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(authorizationCodeAuthenticationProvider));
    }

    private void configure(B builder, AuthorizationCodeGrantConfigurer authorizationCodeGrantConfigurer) throws Exception {
        RequestCache requestCache;
        OAuth2AuthorizationRequestRedirectFilter authorizationRequestFilter;
        if (((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestResolver != null) {
            authorizationRequestFilter = new OAuth2AuthorizationRequestRedirectFilter(((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestResolver);
        } else {
            String authorizationRequestBaseUri = ((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestBaseUri;
            if (authorizationRequestBaseUri == null) {
                authorizationRequestBaseUri = "/oauth2/authorization";
            }
            authorizationRequestFilter = new OAuth2AuthorizationRequestRedirectFilter(OAuth2ClientConfigurerUtils.getClientRegistrationRepository(builder), authorizationRequestBaseUri);
        }
        if (((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestRepository != null) {
            authorizationRequestFilter.setAuthorizationRequestRepository(((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestRepository);
        }
        if ((requestCache = builder.getSharedObject(RequestCache.class)) != null) {
            authorizationRequestFilter.setRequestCache(requestCache);
        }
        builder.addFilter((Filter)this.postProcess(authorizationRequestFilter));
        AuthenticationManager authenticationManager = builder.getSharedObject(AuthenticationManager.class);
        OAuth2AuthorizationCodeGrantFilter authorizationCodeGrantFilter = new OAuth2AuthorizationCodeGrantFilter(OAuth2ClientConfigurerUtils.getClientRegistrationRepository(builder), OAuth2ClientConfigurerUtils.getAuthorizedClientRepository(builder), authenticationManager);
        if (((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestRepository != null) {
            authorizationCodeGrantFilter.setAuthorizationRequestRepository(((AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig)authorizationCodeGrantConfigurer.authorizationEndpointConfig).authorizationRequestRepository);
        }
        builder.addFilter((Filter)this.postProcess(authorizationCodeGrantFilter));
    }

    public class AuthorizationCodeGrantConfigurer {
        private final org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig authorizationEndpointConfig = new AuthorizationEndpointConfig();
        private final org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.TokenEndpointConfig tokenEndpointConfig = new TokenEndpointConfig();

        private AuthorizationCodeGrantConfigurer() {
        }

        public org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig authorizationEndpoint() {
            return this.authorizationEndpointConfig;
        }

        public org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.TokenEndpointConfig tokenEndpoint() {
            return this.tokenEndpointConfig;
        }

        public OAuth2ClientConfigurer<B> and() {
            return OAuth2ClientConfigurer.this;
        }

        public class TokenEndpointConfig {
            private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;

            private TokenEndpointConfig() {
            }

            public org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.TokenEndpointConfig accessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
                Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
                this.accessTokenResponseClient = accessTokenResponseClient;
                return this;
            }

            public AuthorizationCodeGrantConfigurer and() {
                return AuthorizationCodeGrantConfigurer.this;
            }
        }

        public class AuthorizationEndpointConfig {
            private String authorizationRequestBaseUri;
            private OAuth2AuthorizationRequestResolver authorizationRequestResolver;
            private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;

            private AuthorizationEndpointConfig() {
            }

            public org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig baseUri(String authorizationRequestBaseUri) {
                Assert.hasText((String)authorizationRequestBaseUri, (String)"authorizationRequestBaseUri cannot be empty");
                this.authorizationRequestBaseUri = authorizationRequestBaseUri;
                return this;
            }

            public org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig authorizationRequestResolver(OAuth2AuthorizationRequestResolver authorizationRequestResolver) {
                Assert.notNull((Object)authorizationRequestResolver, (String)"authorizationRequestResolver cannot be null");
                this.authorizationRequestResolver = authorizationRequestResolver;
                return this;
            }

            public org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer$AuthorizationCodeGrantConfigurer.AuthorizationEndpointConfig authorizationRequestRepository(AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
                Assert.notNull(authorizationRequestRepository, (String)"authorizationRequestRepository cannot be null");
                this.authorizationRequestRepository = authorizationRequestRepository;
                return this;
            }

            public AuthorizationCodeGrantConfigurer and() {
                return AuthorizationCodeGrantConfigurer.this;
            }
        }
    }
}

