/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public final class RequestCacheConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<RequestCacheConfigurer<H>, H> {
    public RequestCacheConfigurer<H> requestCache(RequestCache requestCache) {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RequestCache.class, requestCache);
        return this;
    }

    @Override
    public void init(H http) throws Exception {
        http.setSharedObject(RequestCache.class, (RequestCache)this.getRequestCache(http));
    }

    @Override
    public void configure(H http) throws Exception {
        RequestCache requestCache = this.getRequestCache(http);
        RequestCacheAwareFilter requestCacheFilter = new RequestCacheAwareFilter(requestCache);
        requestCacheFilter = this.postProcess(requestCacheFilter);
        http.addFilter((Filter)requestCacheFilter);
    }

    private RequestCache getRequestCache(H http) {
        RequestCache result = http.getSharedObject(RequestCache.class);
        if (result != null) {
            return result;
        }
        result = this.getBeanOrNull(RequestCache.class);
        if (result != null) {
            return result;
        }
        HttpSessionRequestCache defaultCache = new HttpSessionRequestCache();
        defaultCache.setRequestMatcher(this.createDefaultSavedRequestMatcher(http));
        return defaultCache;
    }

    private <T> T getBeanOrNull(Class<T> type) {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        try {
            return (T)context.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    private RequestMatcher createDefaultSavedRequestMatcher(H http) {
        ContentNegotiationStrategy contentNegotiationStrategy = http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        NegatedRequestMatcher notFavIcon = new NegatedRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/**/favicon.*"));
        MediaTypeRequestMatcher jsonRequest = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_JSON});
        jsonRequest.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        NegatedRequestMatcher notJson = new NegatedRequestMatcher((RequestMatcher)jsonRequest);
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        boolean isCsrfEnabled = http.getConfigurer(CsrfConfigurer.class) != null;
        ArrayList<Object> matchers = new ArrayList<Object>();
        if (isCsrfEnabled) {
            AntPathRequestMatcher getRequests = new AntPathRequestMatcher("/**", "GET");
            matchers.add(0, getRequests);
        }
        matchers.add(notFavIcon);
        matchers.add(notJson);
        matchers.add(notXRequestedWith);
        return new AndRequestMatcher(matchers);
    }
}

