/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class OpaqueTokenBeanDefinitionParser
implements BeanDefinitionParser {
    static final String INTROSPECTOR_REF = "introspector-ref";
    static final String INTROSPECTION_URI = "introspection-uri";
    static final String CLIENT_ID = "client-id";
    static final String CLIENT_SECRET = "client-secret";

    public BeanDefinition parse(Element element, ParserContext pc) {
        this.validateConfiguration(element, pc);
        BeanMetadataElement introspector = this.getIntrospector(element);
        BeanDefinitionBuilder opaqueTokenProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition(OpaqueTokenAuthenticationProvider.class);
        opaqueTokenProviderBuilder.addConstructorArgValue((Object)introspector);
        return opaqueTokenProviderBuilder.getBeanDefinition();
    }

    void validateConfiguration(Element element, ParserContext pc) {
        boolean usesEndpoint;
        boolean usesIntrospector = element.hasAttribute(INTROSPECTOR_REF);
        boolean bl = usesEndpoint = element.hasAttribute(INTROSPECTION_URI) || element.hasAttribute(CLIENT_ID) || element.hasAttribute(CLIENT_SECRET);
        if (usesIntrospector == usesEndpoint) {
            pc.getReaderContext().error("Please specify either introspector-ref or all of introspection-uri, client-id, and client-secret.", (Object)element);
            return;
        }
        if (!(!usesEndpoint || element.hasAttribute(INTROSPECTION_URI) && element.hasAttribute(CLIENT_ID) && element.hasAttribute(CLIENT_SECRET))) {
            pc.getReaderContext().error("Please specify introspection-uri, client-id, and client-secret together", (Object)element);
        }
    }

    BeanMetadataElement getIntrospector(Element element) {
        String introspectorRef = element.getAttribute(INTROSPECTOR_REF);
        if (!StringUtils.isEmpty((Object)introspectorRef)) {
            return new RuntimeBeanReference(introspectorRef);
        }
        String introspectionUri = element.getAttribute(INTROSPECTION_URI);
        String clientId = element.getAttribute(CLIENT_ID);
        String clientSecret = element.getAttribute(CLIENT_SECRET);
        BeanDefinitionBuilder introspectorBuilder = BeanDefinitionBuilder.rootBeanDefinition(NimbusOpaqueTokenIntrospector.class);
        introspectorBuilder.addConstructorArgValue((Object)introspectionUri);
        introspectorBuilder.addConstructorArgValue((Object)clientId);
        introspectorBuilder.addConstructorArgValue((Object)clientSecret);
        return introspectorBuilder.getBeanDefinition();
    }

    OpaqueTokenBeanDefinitionParser() {
    }
}

