/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class PasswordEncoderParser {
    static final String ATT_REF = "ref";
    public static final String ATT_HASH = "hash";
    static final String ATT_BASE_64 = "base64";
    static final String OPT_HASH_BCRYPT = "bcrypt";
    private static final Map<String, Class<?>> ENCODER_CLASSES = new HashMap();
    private static final Log logger;
    private BeanMetadataElement passwordEncoder;

    public PasswordEncoderParser(Element element, ParserContext parserContext) {
        this.parse(element, parserContext);
    }

    private void parse(Element element, ParserContext parserContext) {
        String ref;
        if (element == null) {
            if (parserContext.getRegistry().containsBeanDefinition("passwordEncoder")) {
                this.passwordEncoder = parserContext.getRegistry().getBeanDefinition("passwordEncoder");
            }
            return;
        }
        String hash = element.getAttribute(ATT_HASH);
        boolean useBase64 = false;
        if (StringUtils.hasText((String)element.getAttribute(ATT_BASE_64))) {
            useBase64 = Boolean.parseBoolean(element.getAttribute(ATT_BASE_64));
        }
        if (StringUtils.hasText((String)(ref = element.getAttribute(ATT_REF)))) {
            this.passwordEncoder = new RuntimeBeanReference(ref);
        } else {
            this.passwordEncoder = PasswordEncoderParser.createPasswordEncoderBeanDefinition(hash, useBase64);
            ((RootBeanDefinition)this.passwordEncoder).setSource(parserContext.extractSource((Object)element));
        }
    }

    public static BeanDefinition createPasswordEncoderBeanDefinition(String hash, boolean useBase64) {
        Class<?> beanClass = ENCODER_CLASSES.get(hash);
        BeanDefinitionBuilder beanBldr = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        return beanBldr.getBeanDefinition();
    }

    public BeanMetadataElement getPasswordEncoder() {
        return this.passwordEncoder;
    }

    static {
        ENCODER_CLASSES.put(OPT_HASH_BCRYPT, BCryptPasswordEncoder.class);
        logger = LogFactory.getLog(PasswordEncoderParser.class);
    }
}

