/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.reactive.result.method.annotation.OAuth2AuthorizedClientArgumentResolver;
import org.springframework.security.oauth2.client.web.server.AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.ClassUtils;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

final class ReactiveOAuth2ClientImportSelector
implements ImportSelector {
    ReactiveOAuth2ClientImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        if (!ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistration", (ClassLoader)this.getClass().getClassLoader())) {
            return new String[0];
        }
        return new String[]{"org.springframework.security.config.annotation.web.reactive.ReactiveOAuth2ClientImportSelector$OAuth2ClientWebFluxSecurityConfiguration"};
    }

    @Configuration(proxyBeanMethods=false)
    static class OAuth2ClientWebFluxSecurityConfiguration
    implements WebFluxConfigurer {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
        private ReactiveOAuth2AuthorizedClientService authorizedClientService;

        OAuth2ClientWebFluxSecurityConfiguration() {
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            if (this.authorizedClientRepository != null && this.clientRegistrationRepository != null) {
                ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().build();
                DefaultReactiveOAuth2AuthorizedClientManager authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(this.clientRegistrationRepository, this.getAuthorizedClientRepository());
                authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
                configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{new OAuth2AuthorizedClientArgumentResolver((ReactiveOAuth2AuthorizedClientManager)authorizedClientManager)});
            }
        }

        @Autowired(required=false)
        void setClientRegistrationRepository(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            this.clientRegistrationRepository = clientRegistrationRepository;
        }

        @Autowired(required=false)
        void setAuthorizedClientRepository(ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
            this.authorizedClientRepository = authorizedClientRepository;
        }

        @Autowired(required=false)
        void setAuthorizedClientService(List<ReactiveOAuth2AuthorizedClientService> authorizedClientService) {
            if (authorizedClientService.size() == 1) {
                this.authorizedClientService = authorizedClientService.get(0);
            }
        }

        private ServerOAuth2AuthorizedClientRepository getAuthorizedClientRepository() {
            if (this.authorizedClientRepository != null) {
                return this.authorizedClientRepository;
            }
            if (this.authorizedClientService != null) {
                return new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(this.authorizedClientService);
            }
            return null;
        }
    }
}

