/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class DefaultFilterChainValidator
implements FilterChainProxy.FilterChainValidator {
    private static final Authentication TEST = new TestingAuthenticationToken((Object)"", (Object)"", Collections.emptyList());
    private final Log logger = LogFactory.getLog(this.getClass());

    public void validate(FilterChainProxy fcp) {
        for (SecurityFilterChain filterChain : fcp.getFilterChains()) {
            this.checkLoginPageIsntProtected(fcp, filterChain.getFilters());
            this.checkFilterStack(filterChain.getFilters());
        }
        this.checkPathOrder(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
        this.checkForDuplicateMatchers(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
    }

    private void checkPathOrder(List<SecurityFilterChain> filterChains) {
        Iterator<SecurityFilterChain> chains = filterChains.iterator();
        while (chains.hasNext()) {
            RequestMatcher matcher = ((DefaultSecurityFilterChain)chains.next()).getRequestMatcher();
            if (!AnyRequestMatcher.INSTANCE.equals(matcher) || !chains.hasNext()) continue;
            throw new IllegalArgumentException("A universal match pattern ('/**') is defined  before other patterns in the filter chain, causing them to be ignored. Please check the ordering in your <security:http> namespace or FilterChainProxy bean configuration");
        }
    }

    private void checkForDuplicateMatchers(List<SecurityFilterChain> chains) {
        while (chains.size() > 1) {
            DefaultSecurityFilterChain chain = (DefaultSecurityFilterChain)chains.remove(0);
            for (SecurityFilterChain test : chains) {
                if (!chain.getRequestMatcher().equals(((DefaultSecurityFilterChain)test).getRequestMatcher())) continue;
                throw new IllegalArgumentException("The FilterChainProxy contains two filter chains using the matcher " + String.valueOf(chain.getRequestMatcher()) + ". If you are using multiple <http> namespace elements, you must use a 'pattern' attribute to define the request patterns to which they apply.");
            }
        }
    }

    private <F extends Filter> F getFilter(Class<F> type, List<Filter> filters) {
        for (Filter f : filters) {
            if (!type.isAssignableFrom(f.getClass())) continue;
            return (F)f;
        }
        return null;
    }

    private void checkFilterStack(List<Filter> filters) {
        this.checkForDuplicates(SecurityContextPersistenceFilter.class, filters);
        this.checkForDuplicates(UsernamePasswordAuthenticationFilter.class, filters);
        this.checkForDuplicates(SessionManagementFilter.class, filters);
        this.checkForDuplicates(BasicAuthenticationFilter.class, filters);
        this.checkForDuplicates(SecurityContextHolderAwareRequestFilter.class, filters);
        this.checkForDuplicates(JaasApiIntegrationFilter.class, filters);
        this.checkForDuplicates(ExceptionTranslationFilter.class, filters);
        this.checkForDuplicates(FilterSecurityInterceptor.class, filters);
        this.checkForDuplicates(AuthorizationFilter.class, filters);
    }

    private void checkForDuplicates(Class<? extends Filter> clazz, List<Filter> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter f1 = filters.get(i);
            if (!clazz.isAssignableFrom(f1.getClass())) continue;
            for (int j = i + 1; j < filters.size(); ++j) {
                Filter f2 = filters.get(j);
                if (!clazz.isAssignableFrom(f2.getClass())) continue;
                this.logger.warn((Object)("Possible error: Filters at position " + i + " and " + j + " are both instances of " + clazz.getName()));
                return;
            }
        }
    }

    private void checkLoginPageIsntProtected(FilterChainProxy fcp, List<Filter> filterStack) {
        ExceptionTranslationFilter exceptions = this.getFilter(ExceptionTranslationFilter.class, filterStack);
        if (exceptions == null || !(exceptions.getAuthenticationEntryPoint() instanceof LoginUrlAuthenticationEntryPoint)) {
            return;
        }
        String loginPage = ((LoginUrlAuthenticationEntryPoint)exceptions.getAuthenticationEntryPoint()).getLoginFormUrl();
        this.logger.info((Object)("Checking whether login URL '" + loginPage + "' is accessible with your configuration"));
        FilterInvocation loginRequest = new FilterInvocation(loginPage, "POST");
        List filters = null;
        try {
            filters = fcp.getFilters(loginPage);
        }
        catch (Exception ex) {
            this.logger.info((Object)"Failed to obtain filter chain information for the login page. Unable to complete check.");
        }
        if (filters == null || filters.isEmpty()) {
            this.logger.debug((Object)"Filter chain is empty for the login page");
            return;
        }
        if (this.getFilter(DefaultLoginPageGeneratingFilter.class, filters) != null) {
            this.logger.debug((Object)"Default generated login page is in use");
            return;
        }
        if (this.checkLoginPageIsPublic(filters, loginRequest)) {
            return;
        }
        AnonymousAuthenticationFilter anonymous = this.getFilter(AnonymousAuthenticationFilter.class, filters);
        if (anonymous == null) {
            this.logger.warn((Object)"The login page is being protected by the filter chain, but you don't appear to have anonymous authentication enabled. This is almost certainly an error.");
            return;
        }
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", anonymous.getPrincipal(), (Collection)anonymous.getAuthorities());
        Supplier<Boolean> check = this.deriveAnonymousCheck(filters, loginRequest, token);
        try {
            boolean allowed = check.get();
            if (!allowed) {
                this.logger.warn((Object)"Anonymous access to the login page doesn't appear to be enabled. This is almost certainly an error. Please check your configuration allows unauthenticated access to the configured login page. (Simulated access was rejected)");
            }
        }
        catch (Exception ex) {
            this.logger.info((Object)"Unable to check access to the login page to determine if anonymous access is allowed. This might be an error, but can happen under normal circumstances.", (Throwable)ex);
        }
    }

    private boolean checkLoginPageIsPublic(List<Filter> filters, FilterInvocation loginRequest) {
        FilterSecurityInterceptor authorizationInterceptor = this.getFilter(FilterSecurityInterceptor.class, filters);
        if (authorizationInterceptor != null) {
            FilterInvocationSecurityMetadataSource fids = authorizationInterceptor.getSecurityMetadataSource();
            Collection attributes = fids.getAttributes((Object)loginRequest);
            if (attributes == null) {
                this.logger.debug((Object)"No access attributes defined for login page URL");
                if (authorizationInterceptor.isRejectPublicInvocations()) {
                    this.logger.warn((Object)"FilterSecurityInterceptor is configured to reject public invocations. Your login page may not be accessible.");
                }
                return true;
            }
            return false;
        }
        AuthorizationFilter authorizationFilter = this.getFilter(AuthorizationFilter.class, filters);
        if (authorizationFilter != null) {
            AuthorizationManager authorizationManager = authorizationFilter.getAuthorizationManager();
            try {
                AuthorizationDecision decision = authorizationManager.check(() -> TEST, (Object)loginRequest.getHttpRequest());
                return decision != null && decision.isGranted();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private Supplier<Boolean> deriveAnonymousCheck(List<Filter> filters, FilterInvocation loginRequest, AnonymousAuthenticationToken token) {
        FilterSecurityInterceptor authorizationInterceptor = this.getFilter(FilterSecurityInterceptor.class, filters);
        if (authorizationInterceptor != null) {
            return () -> {
                FilterInvocationSecurityMetadataSource source = authorizationInterceptor.getSecurityMetadataSource();
                Collection attributes = source.getAttributes((Object)loginRequest);
                try {
                    authorizationInterceptor.getAccessDecisionManager().decide((Authentication)token, (Object)loginRequest, attributes);
                    return true;
                }
                catch (AccessDeniedException ex) {
                    return false;
                }
            };
        }
        AuthorizationFilter authorizationFilter = this.getFilter(AuthorizationFilter.class, filters);
        if (authorizationFilter != null) {
            return () -> {
                AuthorizationManager authorizationManager = authorizationFilter.getAuthorizationManager();
                AuthorizationDecision decision = authorizationManager.check(() -> token, (Object)loginRequest.getHttpRequest());
                return decision != null && decision.isGranted();
            };
        }
        return () -> true;
    }
}

