/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.config.web.server.OAuth2ErrorEncoder;
import org.springframework.security.config.web.server.OidcBackChannelLogoutAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.server.session.InMemoryReactiveOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.server.session.ReactiveOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionInformation;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

final class OidcBackChannelServerLogoutHandler
implements ServerLogoutHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ReactiveOidcSessionRegistry sessionRegistry = new InMemoryReactiveOidcSessionRegistry();
    private final HttpMessageWriter<OAuth2Error> errorHttpMessageConverter = new EncoderHttpMessageWriter((Encoder)new OAuth2ErrorEncoder());
    private WebClient web = WebClient.create();
    private String logoutUri = "{baseScheme}://localhost{basePort}/logout";
    private String sessionCookieName = "SESSION";

    OidcBackChannelServerLogoutHandler() {
    }

    public Mono<Void> logout(WebFilterExchange exchange, Authentication authentication) {
        if (!(authentication instanceof OidcBackChannelLogoutAuthentication)) {
            return Mono.defer(() -> {
                if (this.logger.isDebugEnabled()) {
                    String message = "Did not perform OIDC Back-Channel Logout since authentication [%s] was of the wrong type";
                    this.logger.debug((Object)String.format(message, authentication.getClass().getSimpleName()));
                }
                return Mono.empty();
            });
        }
        OidcBackChannelLogoutAuthentication token = (OidcBackChannelLogoutAuthentication)authentication;
        AtomicInteger totalCount = new AtomicInteger(0);
        AtomicInteger invalidatedCount = new AtomicInteger(0);
        return this.sessionRegistry.removeSessionInformation(token.getPrincipal()).concatMap(session -> {
            totalCount.incrementAndGet();
            return this.eachLogout(exchange, (OidcSessionInformation)session).flatMap(response -> {
                invalidatedCount.incrementAndGet();
                return Mono.empty();
            }).onErrorResume(ex -> {
                this.logger.debug((Object)"Failed to invalidate session", ex);
                return this.sessionRegistry.saveSessionInformation(session).then(Mono.just((Object)ex.getMessage()));
            });
        }).collectList().flatMap(list -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Invalidated %d out of %d sessions", invalidatedCount.intValue(), totalCount.intValue()));
            }
            if (!list.isEmpty()) {
                return this.handleLogoutFailure(exchange.getExchange(), this.oauth2Error((Collection<?>)list));
            }
            return Mono.empty();
        });
    }

    private Mono<ResponseEntity<Void>> eachLogout(WebFilterExchange exchange, OidcSessionInformation session) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cookie", this.sessionCookieName + "=" + session.getSessionId());
        for (Map.Entry credential : session.getAuthorities().entrySet()) {
            headers.add((String)credential.getKey(), (String)credential.getValue());
        }
        String logout = this.computeLogoutEndpoint(exchange.getExchange().getRequest());
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.web.post().uri(logout, new Object[0])).headers(h -> h.putAll((Map)headers))).retrieve().toBodilessEntity();
    }

    String computeLogoutEndpoint(ServerHttpRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getURI()).replacePath(request.getPath().contextPath().value()).replaceQuery(null).fragment(null).build();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        String path = uriComponents.getPath();
        uriVariables.put("basePath", path != null ? path : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        return UriComponentsBuilder.fromUriString((String)this.logoutUri).buildAndExpand(uriVariables).toUriString();
    }

    private OAuth2Error oauth2Error(Collection<?> errors) {
        return new OAuth2Error("partial_logout", "not all sessions were terminated: " + String.valueOf(errors), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }

    private Mono<Void> handleLogoutFailure(ServerWebExchange exchange, OAuth2Error error) {
        exchange.getResponse().setRawStatusCode(Integer.valueOf(400));
        return this.errorHttpMessageConverter.write((Publisher)Mono.just((Object)error), ResolvableType.forClass(Object.class), ResolvableType.forClass(Object.class), MediaType.APPLICATION_JSON, exchange.getRequest(), exchange.getResponse(), Collections.emptyMap());
    }

    void setSessionRegistry(ReactiveOidcSessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    void setWebClient(WebClient web) {
        Assert.notNull((Object)web, (String)"web cannot be null");
        this.web = web;
    }

    void setLogoutUri(String logoutUri) {
        Assert.hasText((String)logoutUri, (String)"logoutUri cannot be empty");
        this.logoutUri = logoutUri;
    }

    void setSessionCookieName(String sessionCookieName) {
        Assert.hasText((String)sessionCookieName, (String)"clientSessionCookieName cannot be empty");
        this.sessionCookieName = sessionCookieName;
    }
}

