/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.authentication.password.CompromisedPasswordChecker;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

@Order(value=2147478647)
class InitializeUserDetailsBeanManagerConfigurer
extends GlobalAuthenticationConfigurerAdapter {
    static final int DEFAULT_ORDER = 2147478647;
    private final ApplicationContext context;

    InitializeUserDetailsBeanManagerConfigurer(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void init(AuthenticationManagerBuilder auth) throws Exception {
        auth.apply(new InitializeUserDetailsManagerConfigurer());
    }

    class InitializeUserDetailsManagerConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        private final Log logger = LogFactory.getLog(this.getClass());

        InitializeUserDetailsManagerConfigurer() {
        }

        @Override
        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            List<BeanWithName<UserDetailsService>> userDetailsServices = this.getBeansWithName(UserDetailsService.class);
            if (auth.isConfigured()) {
                if (!userDetailsServices.isEmpty()) {
                    this.logger.warn((Object)"Global AuthenticationManager configured with an AuthenticationProvider bean. UserDetailsService beans will not be used by Spring Security for automatically configuring username/password login. Consider removing the AuthenticationProvider bean. Alternatively, consider using the UserDetailsService in a manually instantiated DaoAuthenticationProvider. If the current configuration is intentional, to turn off this warning, increase the logging level of 'org.springframework.security.config.annotation.authentication.configuration.InitializeUserDetailsBeanManagerConfigurer' to ERROR");
                }
                return;
            }
            if (userDetailsServices.isEmpty()) {
                return;
            }
            if (userDetailsServices.size() > 1) {
                List<String> beanNames = userDetailsServices.stream().map(BeanWithName::getName).toList();
                this.logger.warn((Object)LogMessage.format((String)"Found %s UserDetailsService beans, with names %s. Global Authentication Manager will not use a UserDetailsService for username/password login. Consider publishing a single UserDetailsService bean.", (Object)userDetailsServices.size(), beanNames));
                return;
            }
            UserDetailsService userDetailsService = userDetailsServices.get(0).getBean();
            String userDetailsServiceBeanName = userDetailsServices.get(0).getName();
            PasswordEncoder passwordEncoder = this.getBeanOrNull(PasswordEncoder.class);
            UserDetailsPasswordService passwordManager = this.getBeanOrNull(UserDetailsPasswordService.class);
            CompromisedPasswordChecker passwordChecker = this.getBeanOrNull(CompromisedPasswordChecker.class);
            DaoAuthenticationProvider provider = passwordEncoder != null ? new DaoAuthenticationProvider(passwordEncoder) : new DaoAuthenticationProvider();
            provider.setUserDetailsService(userDetailsService);
            if (passwordManager != null) {
                provider.setUserDetailsPasswordService(passwordManager);
            }
            if (passwordChecker != null) {
                provider.setCompromisedPasswordChecker(passwordChecker);
            }
            provider.afterPropertiesSet();
            auth.authenticationProvider((AuthenticationProvider)provider);
            this.logger.info((Object)LogMessage.format((String)"Global AuthenticationManager configured with UserDetailsService bean with name %s", (Object)userDetailsServiceBeanName));
        }

        private <T> T getBeanOrNull(Class<T> type) {
            return (T)InitializeUserDetailsBeanManagerConfigurer.this.context.getBeanProvider(type).getIfUnique();
        }

        private <T> List<BeanWithName<T>> getBeansWithName(Class<T> type) {
            String[] beanNames;
            ArrayList<BeanWithName<T>> beanWithNames = new ArrayList<BeanWithName<T>>();
            for (String beanName : beanNames = InitializeUserDetailsBeanManagerConfigurer.this.context.getBeanNamesForType(type)) {
                Object bean = InitializeUserDetailsBeanManagerConfigurer.this.context.getBean(beanName, type);
                beanWithNames.add(new BeanWithName<Object>(bean, beanName));
            }
            return beanWithNames;
        }

        static class BeanWithName<T> {
            private final T bean;
            private final String name;

            BeanWithName(T bean, String name) {
                this.bean = bean;
                this.name = name;
            }

            T getBean() {
                return this.bean;
            }

            String getName() {
                return this.name;
            }
        }
    }
}

