/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.OAuth2ClientBeanDefinitionParserUtils;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationCodeGrantFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

final class OAuth2ClientBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ELT_AUTHORIZATION_CODE_GRANT = "authorization-code-grant";
    private static final String ATT_AUTHORIZATION_REQUEST_REPOSITORY_REF = "authorization-request-repository-ref";
    private static final String ATT_AUTHORIZATION_REQUEST_RESOLVER_REF = "authorization-request-resolver-ref";
    private static final String ATT_AUTHORIZATION_REDIRECT_STRATEGY_REF = "authorization-redirect-strategy-ref";
    private static final String ATT_ACCESS_TOKEN_RESPONSE_CLIENT_REF = "access-token-response-client-ref";
    private final BeanReference requestCache;
    private final BeanReference authenticationManager;
    private final BeanReference authenticationFilterSecurityContextRepositoryRef;
    private final BeanMetadataElement authenticationFilterSecurityContextHolderStrategy;
    private BeanDefinition defaultAuthorizedClientRepository;
    private BeanDefinition authorizationRequestRedirectFilter;
    private BeanDefinition authorizationCodeGrantFilter;
    private BeanDefinition authorizationCodeAuthenticationProvider;

    OAuth2ClientBeanDefinitionParser(BeanReference requestCache, BeanReference authenticationManager, BeanReference authenticationFilterSecurityContextRepositoryRef, BeanMetadataElement authenticationFilterSecurityContextHolderStrategy) {
        this.requestCache = requestCache;
        this.authenticationManager = authenticationManager;
        this.authenticationFilterSecurityContextRepositoryRef = authenticationFilterSecurityContextRepositoryRef;
        this.authenticationFilterSecurityContextHolderStrategy = authenticationFilterSecurityContextHolderStrategy;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String authorizationRequestResolverRef;
        Element authorizationCodeGrantElt = DomUtils.getChildElementByTagName((Element)element, (String)ELT_AUTHORIZATION_CODE_GRANT);
        BeanMetadataElement clientRegistrationRepository = OAuth2ClientBeanDefinitionParserUtils.getClientRegistrationRepository(element);
        BeanMetadataElement authorizedClientRepository = OAuth2ClientBeanDefinitionParserUtils.getAuthorizedClientRepository(element);
        if (authorizedClientRepository == null) {
            BeanMetadataElement authorizedClientService = OAuth2ClientBeanDefinitionParserUtils.getAuthorizedClientService(element);
            this.defaultAuthorizedClientRepository = OAuth2ClientBeanDefinitionParserUtils.createDefaultAuthorizedClientRepository(clientRegistrationRepository, authorizedClientService);
            authorizedClientRepository = new RuntimeBeanReference(OAuth2AuthorizedClientRepository.class);
        }
        BeanMetadataElement authorizationRequestRepository = this.getAuthorizationRequestRepository(authorizationCodeGrantElt);
        BeanMetadataElement authorizationRedirectStrategy = this.getAuthorizationRedirectStrategy(authorizationCodeGrantElt);
        BeanDefinitionBuilder authorizationRequestRedirectFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationRequestRedirectFilter.class);
        String string = authorizationRequestResolverRef = authorizationCodeGrantElt != null ? authorizationCodeGrantElt.getAttribute(ATT_AUTHORIZATION_REQUEST_RESOLVER_REF) : null;
        if (StringUtils.hasLength((String)authorizationRequestResolverRef)) {
            authorizationRequestRedirectFilterBuilder.addConstructorArgReference(authorizationRequestResolverRef);
        } else {
            authorizationRequestRedirectFilterBuilder.addConstructorArgValue((Object)clientRegistrationRepository);
        }
        this.authorizationRequestRedirectFilter = authorizationRequestRedirectFilterBuilder.addPropertyValue("authorizationRequestRepository", (Object)authorizationRequestRepository).addPropertyValue("authorizationRedirectStrategy", (Object)authorizationRedirectStrategy).addPropertyValue("requestCache", (Object)this.requestCache).getBeanDefinition();
        BeanDefinitionBuilder authorizationCodeGrantFilterBldr = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationCodeGrantFilter.class).addConstructorArgValue((Object)clientRegistrationRepository).addConstructorArgValue((Object)authorizedClientRepository).addConstructorArgValue((Object)this.authenticationManager).addPropertyValue("authorizationRequestRepository", (Object)authorizationRequestRepository);
        this.authorizationCodeGrantFilter = authorizationCodeGrantFilterBldr.getBeanDefinition();
        BeanMetadataElement accessTokenResponseClient = this.getAccessTokenResponseClient(authorizationCodeGrantElt);
        this.authorizationCodeAuthenticationProvider = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationCodeAuthenticationProvider.class).addConstructorArgValue((Object)accessTokenResponseClient).getBeanDefinition();
        return null;
    }

    private BeanMetadataElement getAuthorizationRequestRepository(Element element) {
        String authorizationRequestRepositoryRef;
        String string = authorizationRequestRepositoryRef = element != null ? element.getAttribute(ATT_AUTHORIZATION_REQUEST_REPOSITORY_REF) : null;
        if (StringUtils.hasLength((String)authorizationRequestRepositoryRef)) {
            return new RuntimeBeanReference(authorizationRequestRepositoryRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository").getBeanDefinition();
    }

    private BeanMetadataElement getAuthorizationRedirectStrategy(Element element) {
        String authorizationRedirectStrategyRef;
        String string = authorizationRedirectStrategyRef = element != null ? element.getAttribute(ATT_AUTHORIZATION_REDIRECT_STRATEGY_REF) : null;
        if (StringUtils.hasText((String)authorizationRedirectStrategyRef)) {
            return new RuntimeBeanReference(authorizationRedirectStrategyRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.web.DefaultRedirectStrategy").getBeanDefinition();
    }

    private BeanMetadataElement getAccessTokenResponseClient(Element element) {
        String accessTokenResponseClientRef;
        String string = accessTokenResponseClientRef = element != null ? element.getAttribute(ATT_ACCESS_TOKEN_RESPONSE_CLIENT_REF) : null;
        if (StringUtils.hasLength((String)accessTokenResponseClientRef)) {
            return new RuntimeBeanReference(accessTokenResponseClientRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient").getBeanDefinition();
    }

    BeanDefinition getDefaultAuthorizedClientRepository() {
        return this.defaultAuthorizedClientRepository;
    }

    BeanDefinition getAuthorizationRequestRedirectFilter() {
        return this.authorizationRequestRedirectFilter;
    }

    BeanDefinition getAuthorizationCodeGrantFilter() {
        return this.authorizationCodeGrantFilter;
    }

    BeanDefinition getAuthorizationCodeAuthenticationProvider() {
        return this.authorizationCodeAuthenticationProvider;
    }
}

