/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.DefaultOAuth2TokenCustomizers;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class OAuth2ConfigurerUtils {
    private OAuth2ConfigurerUtils() {
    }

    static String withMultipleIssuersPattern(String endpointUri) {
        Assert.hasText((String)endpointUri, (String)"endpointUri cannot be empty");
        return endpointUri.startsWith("/") ? "/**" + endpointUri : "/**/" + endpointUri;
    }

    static RegisteredClientRepository getRegisteredClientRepository(HttpSecurity httpSecurity) {
        RegisteredClientRepository registeredClientRepository = httpSecurity.getSharedObject(RegisteredClientRepository.class);
        if (registeredClientRepository == null) {
            registeredClientRepository = OAuth2ConfigurerUtils.getBean(httpSecurity, RegisteredClientRepository.class);
            httpSecurity.setSharedObject(RegisteredClientRepository.class, registeredClientRepository);
        }
        return registeredClientRepository;
    }

    static OAuth2AuthorizationService getAuthorizationService(HttpSecurity httpSecurity) {
        OAuth2AuthorizationService authorizationService = httpSecurity.getSharedObject(OAuth2AuthorizationService.class);
        if (authorizationService == null) {
            authorizationService = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, OAuth2AuthorizationService.class);
            if (authorizationService == null) {
                authorizationService = new InMemoryOAuth2AuthorizationService();
            }
            httpSecurity.setSharedObject(OAuth2AuthorizationService.class, authorizationService);
        }
        return authorizationService;
    }

    static OAuth2AuthorizationConsentService getAuthorizationConsentService(HttpSecurity httpSecurity) {
        OAuth2AuthorizationConsentService authorizationConsentService = httpSecurity.getSharedObject(OAuth2AuthorizationConsentService.class);
        if (authorizationConsentService == null) {
            authorizationConsentService = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, OAuth2AuthorizationConsentService.class);
            if (authorizationConsentService == null) {
                authorizationConsentService = new InMemoryOAuth2AuthorizationConsentService();
            }
            httpSecurity.setSharedObject(OAuth2AuthorizationConsentService.class, authorizationConsentService);
        }
        return authorizationConsentService;
    }

    static OAuth2TokenGenerator<? extends OAuth2Token> getTokenGenerator(HttpSecurity httpSecurity) {
        OAuth2TokenGenerator tokenGenerator = httpSecurity.getSharedObject(OAuth2TokenGenerator.class);
        if (tokenGenerator == null) {
            tokenGenerator = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, OAuth2TokenGenerator.class);
            if (tokenGenerator == null) {
                JwtGenerator jwtGenerator = OAuth2ConfigurerUtils.getJwtGenerator(httpSecurity);
                OAuth2AccessTokenGenerator accessTokenGenerator = new OAuth2AccessTokenGenerator();
                accessTokenGenerator.setAccessTokenCustomizer(OAuth2ConfigurerUtils.getAccessTokenCustomizer(httpSecurity));
                OAuth2RefreshTokenGenerator refreshTokenGenerator = new OAuth2RefreshTokenGenerator();
                tokenGenerator = jwtGenerator != null ? new DelegatingOAuth2TokenGenerator(new OAuth2TokenGenerator[]{jwtGenerator, accessTokenGenerator, refreshTokenGenerator}) : new DelegatingOAuth2TokenGenerator(new OAuth2TokenGenerator[]{accessTokenGenerator, refreshTokenGenerator});
            }
            httpSecurity.setSharedObject(OAuth2TokenGenerator.class, tokenGenerator);
        }
        return tokenGenerator;
    }

    private static JwtGenerator getJwtGenerator(HttpSecurity httpSecurity) {
        JwtEncoder jwtEncoder;
        JwtGenerator jwtGenerator = httpSecurity.getSharedObject(JwtGenerator.class);
        if (jwtGenerator == null && (jwtEncoder = OAuth2ConfigurerUtils.getJwtEncoder(httpSecurity)) != null) {
            jwtGenerator = new JwtGenerator(jwtEncoder);
            jwtGenerator.setJwtCustomizer(OAuth2ConfigurerUtils.getJwtCustomizer(httpSecurity));
            httpSecurity.setSharedObject(JwtGenerator.class, jwtGenerator);
        }
        return jwtGenerator;
    }

    private static JwtEncoder getJwtEncoder(HttpSecurity httpSecurity) {
        JwtEncoder jwtEncoder = httpSecurity.getSharedObject(JwtEncoder.class);
        if (jwtEncoder == null) {
            JWKSource<SecurityContext> jwkSource;
            jwtEncoder = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, JwtEncoder.class);
            if (jwtEncoder == null && (jwkSource = OAuth2ConfigurerUtils.getJwkSource(httpSecurity)) != null) {
                jwtEncoder = new NimbusJwtEncoder(jwkSource);
            }
            if (jwtEncoder != null) {
                httpSecurity.setSharedObject(JwtEncoder.class, jwtEncoder);
            }
        }
        return jwtEncoder;
    }

    static JWKSource<SecurityContext> getJwkSource(HttpSecurity httpSecurity) {
        ResolvableType type;
        JWKSource jwkSource = httpSecurity.getSharedObject(JWKSource.class);
        if (jwkSource == null && (jwkSource = (JWKSource)OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, type = ResolvableType.forClassWithGenerics(JWKSource.class, (Class[])new Class[]{SecurityContext.class}))) != null) {
            httpSecurity.setSharedObject(JWKSource.class, jwkSource);
        }
        return jwkSource;
    }

    private static OAuth2TokenCustomizer<JwtEncodingContext> getJwtCustomizer(HttpSecurity httpSecurity) {
        OAuth2TokenCustomizer<JwtEncodingContext> defaultJwtCustomizer = DefaultOAuth2TokenCustomizers.jwtCustomizer();
        ResolvableType type = ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{JwtEncodingContext.class});
        OAuth2TokenCustomizer jwtCustomizer = (OAuth2TokenCustomizer)OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, type);
        if (jwtCustomizer == null) {
            return defaultJwtCustomizer;
        }
        return context -> {
            defaultJwtCustomizer.customize(context);
            jwtCustomizer.customize(context);
        };
    }

    private static OAuth2TokenCustomizer<OAuth2TokenClaimsContext> getAccessTokenCustomizer(HttpSecurity httpSecurity) {
        OAuth2TokenCustomizer<OAuth2TokenClaimsContext> defaultAccessTokenCustomizer = DefaultOAuth2TokenCustomizers.accessTokenCustomizer();
        ResolvableType type = ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{OAuth2TokenClaimsContext.class});
        OAuth2TokenCustomizer accessTokenCustomizer = (OAuth2TokenCustomizer)OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, type);
        if (accessTokenCustomizer == null) {
            return defaultAccessTokenCustomizer;
        }
        return context -> {
            defaultAccessTokenCustomizer.customize(context);
            accessTokenCustomizer.customize(context);
        };
    }

    static AuthorizationServerSettings getAuthorizationServerSettings(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = httpSecurity.getSharedObject(AuthorizationServerSettings.class);
        if (authorizationServerSettings == null) {
            authorizationServerSettings = OAuth2ConfigurerUtils.getBean(httpSecurity, AuthorizationServerSettings.class);
            httpSecurity.setSharedObject(AuthorizationServerSettings.class, authorizationServerSettings);
        }
        return authorizationServerSettings;
    }

    static <T> T getBean(HttpSecurity httpSecurity, Class<T> type) {
        return (T)httpSecurity.getSharedObject(ApplicationContext.class).getBean(type);
    }

    static <T> T getBean(HttpSecurity httpSecurity, ResolvableType type) {
        ApplicationContext context = httpSecurity.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)context.getBean(names[0]);
        }
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        throw new NoSuchBeanDefinitionException(type);
    }

    static <T> T getOptionalBean(HttpSecurity httpSecurity, Class<T> type) {
        Map beansMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)httpSecurity.getSharedObject(ApplicationContext.class)), type);
        if (beansMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(type, beansMap.size(), "Expected single matching bean of type '" + type.getName() + "' but found " + beansMap.size() + ": " + StringUtils.collectionToCommaDelimitedString(beansMap.keySet()));
        }
        return !beansMap.isEmpty() ? (T)beansMap.values().iterator().next() : null;
    }

    static <T> T getOptionalBean(HttpSecurity httpSecurity, ResolvableType type) {
        ApplicationContext context = httpSecurity.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        return (T)(names.length == 1 ? context.getBean(names[0]) : null);
    }
}

