/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.encrypt;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.util.CipherUtils;
import org.springframework.security.crypto.util.EncodingUtils;

final class AesBytesEncryptor
implements BytesEncryptor {
    private final SecretKey secretKey;
    private final Cipher encryptor;
    private final Cipher decryptor;
    private final BytesKeyGenerator ivGenerator;
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";

    public AesBytesEncryptor(String password, String salt, BytesKeyGenerator ivGenerator) {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), EncodingUtils.hexDecode(salt), 1024, 256);
        SecretKey secretKey = CipherUtils.newSecretKey("PBKDF2WithHmacSHA1", keySpec);
        this.secretKey = new SecretKeySpec(secretKey.getEncoded(), "AES");
        this.encryptor = CipherUtils.newCipher(AES_ALGORITHM);
        this.decryptor = CipherUtils.newCipher(AES_ALGORITHM);
        this.ivGenerator = ivGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] bytes) {
        Cipher cipher = this.encryptor;
        synchronized (cipher) {
            byte[] iv = this.ivGenerator.generateKey();
            CipherUtils.initCipher(this.encryptor, 1, this.secretKey, new IvParameterSpec(iv));
            byte[] encrypted = CipherUtils.doFinal(this.encryptor, bytes);
            return EncodingUtils.concatenate(iv, encrypted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] encryptedBytes) {
        Cipher cipher = this.decryptor;
        synchronized (cipher) {
            byte[] iv = this.ivPart(encryptedBytes);
            CipherUtils.initCipher(this.decryptor, 2, this.secretKey, new IvParameterSpec(iv));
            return CipherUtils.doFinal(this.decryptor, this.cipherPart(encryptedBytes, iv));
        }
    }

    private byte[] ivPart(byte[] encrypted) {
        return EncodingUtils.subArray(encrypted, 0, this.ivGenerator.getKeyLength());
    }

    private byte[] cipherPart(byte[] encrypted, byte[] iv) {
        return EncodingUtils.subArray(encrypted, iv.length, encrypted.length);
    }
}

