/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.encrypt;

import org.springframework.security.crypto.encrypt.AesBytesEncryptor;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.HexEncodingTextEncryptor;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.crypto.keygen.KeyGenerators;

public class Encryptors {
    private static final TextEncryptor NO_OP_TEXT_INSTANCE = new NoOpTextEncryptor();

    public static BytesEncryptor standard(String password, String salt) {
        return new AesBytesEncryptor(password, password, KeyGenerators.secureRandom(16));
    }

    public static TextEncryptor text(String password, String salt) {
        return new HexEncodingTextEncryptor(Encryptors.standard(password, salt));
    }

    public static TextEncryptor queryableText(String password, String salt) {
        return new HexEncodingTextEncryptor(new AesBytesEncryptor(password, salt, KeyGenerators.shared(16)));
    }

    public static TextEncryptor noOpText() {
        return NO_OP_TEXT_INSTANCE;
    }

    private Encryptors() {
    }

    private static final class NoOpTextEncryptor
    implements TextEncryptor {
        private NoOpTextEncryptor() {
        }

        public String encrypt(String text) {
            return text;
        }

        public String decrypt(String encryptedText) {
            return encryptedText;
        }
    }
}

