/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.encrypt;

import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.crypto.util.EncodingUtils;

final class HexEncodingTextEncryptor
implements TextEncryptor {
    private final BytesEncryptor encryptor;

    public HexEncodingTextEncryptor(BytesEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public String encrypt(String text) {
        return EncodingUtils.hexEncode(this.encryptor.encrypt(EncodingUtils.utf8Encode(text)));
    }

    public String decrypt(String encryptedText) {
        return EncodingUtils.utf8Decode(this.encryptor.decrypt(EncodingUtils.hexDecode(encryptedText)));
    }
}

