/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.password;

import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.util.Digester;
import org.springframework.security.crypto.util.EncodingUtils;

public final class StandardPasswordEncoder
implements PasswordEncoder {
    private final Digester digester;
    private final byte[] secret;
    private final BytesKeyGenerator saltGenerator;

    public StandardPasswordEncoder(String secret) {
        this("SHA-256", "SUN", secret);
    }

    public String encode(String rawPassword) {
        return this.encode(rawPassword, this.saltGenerator.generateKey());
    }

    public boolean matches(String rawPassword, String encodedPassword) {
        byte[] digested = this.decode(encodedPassword);
        byte[] salt = EncodingUtils.subArray(digested, 0, this.saltGenerator.getKeyLength());
        return this.matches(digested, this.digest(rawPassword, salt));
    }

    private StandardPasswordEncoder(String algorithm, String provider, String secret) {
        this.digester = new Digester(algorithm, provider);
        this.secret = EncodingUtils.utf8Encode(secret);
        this.saltGenerator = KeyGenerators.secureRandom();
    }

    private String encode(String rawPassword, byte[] salt) {
        byte[] digest = this.digest(rawPassword, salt);
        return EncodingUtils.hexEncode(digest);
    }

    private byte[] digest(String rawPassword, byte[] salt) {
        byte[] digest = this.digester.digest(EncodingUtils.concatenate(salt, this.secret, EncodingUtils.utf8Encode(rawPassword)));
        return EncodingUtils.concatenate(salt, digest);
    }

    private byte[] decode(String encodedPassword) {
        return EncodingUtils.hexDecode(encodedPassword);
    }

    private boolean matches(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < expected.length; ++i) {
            result |= expected[i] ^ actual[i];
        }
        return result == 0;
    }
}

