/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class Digester {
    private final MessageDigest messageDigest;
    private final int iterations = 1024;

    public Digester(String algorithm, String provider) {
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No such hashing algorithm", e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("No such provider for hashing algorithm", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(byte[] value) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            for (int i = 0; i < 1023; ++i) {
                value = this.invokeDigest(value);
            }
            return this.messageDigest.digest(value);
        }
    }

    private byte[] invokeDigest(byte[] value) {
        this.messageDigest.reset();
        return this.messageDigest.digest(value);
    }
}

