/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.util;

import java.io.UnsupportedEncodingException;

public class EncodingUtils {
    public static String hexEncode(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    public static byte[] hexDecode(String s) {
        int len = s.length();
        byte[] r = new byte[len / 2];
        for (int i = 0; i < r.length; ++i) {
            int digit1 = s.charAt(i * 2);
            int digit2 = s.charAt(i * 2 + 1);
            if (digit1 >= 48 && digit1 <= 57) {
                digit1 -= 48;
            } else if (digit1 >= 97 && digit1 <= 102) {
                digit1 -= 87;
            }
            if (digit2 >= 48 && digit2 <= 57) {
                digit2 -= 48;
            } else if (digit2 >= 97 && digit2 <= 102) {
                digit2 -= 87;
            }
            r[i] = (byte)((digit1 << 4) + digit2);
        }
        return r;
    }

    public static byte[] utf8Encode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.encodingException(e);
        }
    }

    public static String utf8Decode(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.encodingException(e);
        }
    }

    public static byte[] concatenate(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] newArray = new byte[length];
        int destPos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, newArray, destPos, array.length);
            destPos += array.length;
        }
        return newArray;
    }

    public static byte[] subArray(byte[] array, int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        byte[] subarray = new byte[length];
        System.arraycopy(array, beginIndex, subarray, 0, length);
        return subarray;
    }

    private EncodingUtils() {
    }

    private static RuntimeException encodingException(UnsupportedEncodingException e) {
        return new IllegalStateException("UTF-8 is not an available char set", e);
    }
}

