/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.encrypt;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import javax.crypto.Cipher;
import org.jspecify.annotations.Nullable;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.RsaAlgorithm;
import org.springframework.security.crypto.encrypt.RsaKeyHelper;
import org.springframework.security.crypto.encrypt.RsaKeyHolder;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class RsaRawEncryptor
implements BytesEncryptor,
TextEncryptor,
RsaKeyHolder {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private RsaAlgorithm algorithm = RsaAlgorithm.DEFAULT;
    private Charset charset;
    private RSAPublicKey publicKey;
    private @Nullable RSAPrivateKey privateKey;
    private Charset defaultCharset;

    public RsaRawEncryptor(RsaAlgorithm algorithm) {
        this(RsaKeyHelper.generateKeyPair(), algorithm);
    }

    public RsaRawEncryptor() {
        this(RsaKeyHelper.generateKeyPair());
    }

    public RsaRawEncryptor(KeyPair keyPair, RsaAlgorithm algorithm) {
        this(DEFAULT_ENCODING, keyPair.getPublic(), keyPair.getPrivate(), algorithm);
    }

    public RsaRawEncryptor(KeyPair keyPair) {
        this(DEFAULT_ENCODING, keyPair.getPublic(), keyPair.getPrivate());
    }

    public RsaRawEncryptor(String pemData) {
        this(RsaKeyHelper.parseKeyPair(pemData));
    }

    public RsaRawEncryptor(PublicKey publicKey) {
        this(DEFAULT_ENCODING, publicKey, null);
    }

    public RsaRawEncryptor(String encoding, PublicKey publicKey, @Nullable PrivateKey privateKey) {
        this(encoding, publicKey, privateKey, RsaAlgorithm.DEFAULT);
    }

    public RsaRawEncryptor(String encoding, PublicKey publicKey, @Nullable PrivateKey privateKey, RsaAlgorithm algorithm) {
        this.charset = Charset.forName(encoding);
        this.publicKey = (RSAPublicKey)publicKey;
        this.privateKey = (RSAPrivateKey)privateKey;
        this.defaultCharset = Charset.forName(DEFAULT_ENCODING);
        this.algorithm = algorithm;
    }

    @Override
    public String getPublicKey() {
        return RsaKeyHelper.encodePublicKey(this.publicKey, "application");
    }

    @Override
    public String encrypt(String text) {
        return new String(Base64.getEncoder().encode(this.encrypt(text.getBytes(this.charset))), this.defaultCharset);
    }

    @Override
    public String decrypt(String encryptedText) {
        if (this.privateKey == null) {
            throw new IllegalStateException("Private key must be provided for decryption");
        }
        return new String(this.decrypt(Base64.getDecoder().decode(encryptedText.getBytes(this.defaultCharset))), this.charset);
    }

    @Override
    public byte[] encrypt(byte[] byteArray) {
        return RsaRawEncryptor.encrypt(byteArray, this.publicKey, this.algorithm);
    }

    @Override
    public byte[] decrypt(byte[] encryptedByteArray) {
        return RsaRawEncryptor.decrypt(encryptedByteArray, this.privateKey, this.algorithm);
    }

    private static byte[] encrypt(byte[] text, PublicKey key, RsaAlgorithm alg) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(text.length);
        try {
            Cipher cipher = Cipher.getInstance(alg.getJceName());
            int limit = Math.min(text.length, alg.getMaxLength());
            int pos = 0;
            while (pos < text.length) {
                cipher.init(1, key);
                cipher.update(text, pos, limit);
                limit = Math.min(text.length - (pos += limit), alg.getMaxLength());
                byte[] buffer = cipher.doFinal();
                output.write(buffer, 0, buffer.length);
            }
            return output.toByteArray();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot encrypt", ex);
        }
    }

    private static byte[] decrypt(byte[] text, @Nullable RSAPrivateKey key, RsaAlgorithm alg) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(text.length);
        try {
            int limit;
            Cipher cipher = Cipher.getInstance(alg.getJceName());
            int maxLength = RsaRawEncryptor.getByteLength(key);
            for (int pos = 0; pos < text.length; pos += limit) {
                limit = Math.min(text.length - pos, maxLength);
                cipher.init(2, key);
                cipher.update(text, pos, limit);
                byte[] buffer = cipher.doFinal();
                output.write(buffer, 0, buffer.length);
            }
            return output.toByteArray();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot decrypt", ex);
        }
    }

    public static int getByteLength(@Nullable RSAKey key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        int n = key.getModulus().bitLength();
        return n + 7 >> 3;
    }
}

