/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.session.SimpleRedirectInvalidSessionStrategy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionManagementConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<H> {
    private SessionAuthenticationStrategy sessionAuthenticationStrategy = new SessionFixationProtectionStrategy();
    private SessionRegistry sessionRegistry = new SessionRegistryImpl();
    private Integer maximumSessions;
    private String expiredUrl;
    private boolean maxSessionsPreventsLogin;
    private SessionCreationPolicy sessionPolicy = SessionCreationPolicy.ifRequired;
    private boolean enableSessionUrlRewriting;
    private String invalidSessionUrl;
    private String sessionAuthenticationErrorUrl;

    public SessionManagementConfigurer<H> invalidSessionUrl(String invalidSessionUrl) {
        this.invalidSessionUrl = invalidSessionUrl;
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationErrorUrl(String sessionAuthenticationErrorUrl) {
        this.sessionAuthenticationErrorUrl = sessionAuthenticationErrorUrl;
        return this;
    }

    public SessionManagementConfigurer<H> enableSessionUrlRewriting(boolean enableSessionUrlRewriting) {
        this.enableSessionUrlRewriting = enableSessionUrlRewriting;
        return this;
    }

    public SessionManagementConfigurer<H> sessionCreationPolicy(SessionCreationPolicy sessionCreationPolicy) {
        Assert.notNull((Object)((Object)sessionCreationPolicy), (String)"sessionCreationPolicy cannot be null");
        this.sessionPolicy = sessionCreationPolicy;
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
        return this;
    }

    public ConcurrencyControlConfigurer maximumSessions(int maximumSessions) {
        this.maximumSessions = maximumSessions;
        this.sessionAuthenticationStrategy = null;
        return new ConcurrencyControlConfigurer();
    }

    @Override
    public void init(H builder) throws Exception {
        RequestCache requestCache;
        SecurityContextRepository securityContextRepository = builder.getSharedObject(SecurityContextRepository.class);
        boolean stateless = this.isStateless();
        if (securityContextRepository == null) {
            if (stateless) {
                builder.setSharedObject(SecurityContextRepository.class, (NullSecurityContextRepository)new NullSecurityContextRepository());
            } else {
                HttpSessionSecurityContextRepository httpSecurityRepository = new HttpSessionSecurityContextRepository();
                httpSecurityRepository.setDisableUrlRewriting(!this.enableSessionUrlRewriting);
                httpSecurityRepository.setAllowSessionCreation(this.isAllowSessionCreation());
                builder.setSharedObject(SecurityContextRepository.class, (HttpSessionSecurityContextRepository)httpSecurityRepository);
            }
        }
        if ((requestCache = builder.getSharedObject(RequestCache.class)) == null && stateless) {
            builder.setSharedObject(RequestCache.class, (NullRequestCache)new NullRequestCache());
        }
        builder.setSharedObject(SessionAuthenticationStrategy.class, (SessionAuthenticationStrategy)this.getSessionAuthenticationStrategy());
    }

    @Override
    public void configure(H http) throws Exception {
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        SessionManagementFilter sessionManagementFilter = new SessionManagementFilter(securityContextRepository, this.getSessionAuthenticationStrategy());
        if (this.sessionAuthenticationErrorUrl != null) {
            sessionManagementFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler(this.sessionAuthenticationErrorUrl));
        }
        if (this.invalidSessionUrl != null) {
            sessionManagementFilter.setInvalidSessionStrategy((InvalidSessionStrategy)new SimpleRedirectInvalidSessionStrategy(this.invalidSessionUrl));
        }
        sessionManagementFilter = this.postProcess(sessionManagementFilter);
        http.addFilter((Filter)sessionManagementFilter);
        if (this.isConcurrentSessionControlEnabled()) {
            ConcurrentSessionFilter concurrentSessionFilter = new ConcurrentSessionFilter(this.sessionRegistry, this.expiredUrl);
            concurrentSessionFilter = this.postProcess(concurrentSessionFilter);
            http.addFilter((Filter)concurrentSessionFilter);
        }
    }

    SessionCreationPolicy getSessionCreationPolicy() {
        return this.sessionPolicy;
    }

    private boolean isAllowSessionCreation() {
        return SessionCreationPolicy.always == this.sessionPolicy || SessionCreationPolicy.ifRequired == this.sessionPolicy;
    }

    private boolean isStateless() {
        return SessionCreationPolicy.stateless == this.sessionPolicy;
    }

    private SessionAuthenticationStrategy getSessionAuthenticationStrategy() {
        if (this.sessionAuthenticationStrategy != null) {
            return this.sessionAuthenticationStrategy;
        }
        if (this.isConcurrentSessionControlEnabled()) {
            ConcurrentSessionControlStrategy concurrentSessionControlStrategy = new ConcurrentSessionControlStrategy(this.sessionRegistry);
            concurrentSessionControlStrategy.setMaximumSessions(this.maximumSessions.intValue());
            concurrentSessionControlStrategy.setExceptionIfMaximumExceeded(this.maxSessionsPreventsLogin);
            this.sessionAuthenticationStrategy = concurrentSessionControlStrategy;
        }
        return this.sessionAuthenticationStrategy;
    }

    private boolean isConcurrentSessionControlEnabled() {
        return this.maximumSessions != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ConcurrencyControlConfigurer {
        public ConcurrencyControlConfigurer expiredUrl(String expiredUrl) {
            SessionManagementConfigurer.this.expiredUrl = expiredUrl;
            return this;
        }

        public ConcurrencyControlConfigurer maxSessionsPreventsLogin(boolean maxSessionsPreventsLogin) {
            SessionManagementConfigurer.this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
            return this;
        }

        public ConcurrencyControlConfigurer sessionRegistry(SessionRegistry sessionRegistry) {
            SessionManagementConfigurer.this.sessionRegistry = sessionRegistry;
            return this;
        }

        public SessionManagementConfigurer<H> and() {
            return SessionManagementConfigurer.this;
        }

        private ConcurrencyControlConfigurer() {
        }
    }
}

