/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.springframework.security.jwt.HeaderParameters;
import org.springframework.security.jwt.JwtAlgorithms;
import org.springframework.security.jwt.JwtHeader;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.Signer;

class JwtHeaderHelper {
    private static final JsonFactory f = new JsonFactory();

    JwtHeaderHelper() {
    }

    static JwtHeader create(String header) {
        byte[] bytes = Codecs.b64UrlDecode(header);
        return new JwtHeader(bytes, JwtHeaderHelper.parseParams(bytes));
    }

    static JwtHeader create(Signer signer) {
        HeaderParameters p = new HeaderParameters(JwtAlgorithms.sigAlg(signer.algorithm()), null, null);
        return new JwtHeader(JwtHeaderHelper.serializeParams(p), p);
    }

    static JwtHeader create(String alg, String enc, byte[] iv) {
        HeaderParameters p = new HeaderParameters(alg, enc, Codecs.utf8Decode(Codecs.b64UrlEncode(iv)));
        return new JwtHeader(JwtHeaderHelper.serializeParams(p), p);
    }

    static HeaderParameters parseParams(byte[] header) {
        JsonParser jp = null;
        try {
            jp = f.createJsonParser(header);
            String alg = null;
            String enc = null;
            String iv = null;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = jp.getCurrentName();
                jp.nextToken();
                if (!JsonToken.VALUE_STRING.equals((Object)jp.getCurrentToken())) {
                    throw new IllegalArgumentException("Header fields must be strings");
                }
                String value = jp.getText();
                if ("alg".equals(fieldname)) {
                    if (alg != null) {
                        throw new IllegalArgumentException("Duplicate 'alg' field");
                    }
                    alg = value;
                } else if ("enc".equals(fieldname)) {
                    if (enc != null) {
                        throw new IllegalArgumentException("Duplicate 'enc' field");
                    }
                    enc = value;
                }
                if ("iv".equals(fieldname)) {
                    if (iv != null) {
                        throw new IllegalArgumentException("Duplicate 'iv' field");
                    }
                    iv = jp.nextToken().asString();
                    continue;
                }
                if (!"typ".equals(fieldname) || "JWT".equalsIgnoreCase(value)) continue;
                throw new IllegalArgumentException("typ is not \"JWT\"");
            }
            HeaderParameters headerParameters = new HeaderParameters(alg, enc, iv);
            return headerParameters;
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static byte[] serializeParams(HeaderParameters params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator g = null;
        try {
            g = f.createJsonGenerator((OutputStream)baos);
            g.writeStartObject();
            g.writeStringField("alg", params.alg);
            if (params.enc != null) {
                g.writeStringField("enc", params.enc);
            }
            if (params.iv != null) {
                g.writeStringField("iv", params.iv);
            }
            g.writeEndObject();
            g.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        finally {
            if (g != null) {
                try {
                    g.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

