/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.ldap.LdapEncoder;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.util.Assert;

public class SpringSecurityLdapTemplate
extends LdapTemplate {
    private static final Log logger = LogFactory.getLog(SpringSecurityLdapTemplate.class);
    public static final String[] NO_ATTRS = new String[0];
    public static final String DN_KEY = "spring.security.ldap.dn";
    private static final boolean RETURN_OBJECT = true;
    private SearchControls searchControls = new SearchControls();

    public SpringSecurityLdapTemplate(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"ContextSource cannot be null");
        this.setContextSource(contextSource);
        this.searchControls.setSearchScope(2);
    }

    public boolean compare(final String dn, String attributeName, final Object value) {
        final String comparisonFilter = "(" + attributeName + "={0})";
        class LdapCompareCallback
        implements ContextExecutor {
            LdapCompareCallback() {
            }

            public Object executeWithContext(DirContext ctx) throws NamingException {
                SearchControls ctls = new SearchControls();
                ctls.setReturningAttributes(NO_ATTRS);
                ctls.setSearchScope(0);
                NamingEnumeration<SearchResult> results = ctx.search(dn, comparisonFilter, new Object[]{value}, ctls);
                Boolean match = results.hasMore();
                LdapUtils.closeEnumeration(results);
                return match;
            }
        }
        Boolean matches = (Boolean)this.executeReadOnly(new LdapCompareCallback());
        return matches;
    }

    public DirContextOperations retrieveEntry(String dn, String[] attributesToRetrieve) {
        return (DirContextOperations)this.executeReadOnly(ctx -> {
            Attributes attrs = ctx.getAttributes(dn, attributesToRetrieve);
            return new DirContextAdapter(attrs, (Name)new DistinguishedName(dn), (Name)new DistinguishedName(ctx.getNameInNamespace()));
        });
    }

    public Set<String> searchForSingleAttributeValues(String base, String filter, Object[] params, String attributeName) {
        String[] attributeNames = new String[]{attributeName};
        Set<Map<String, List<String>>> multipleAttributeValues = this.searchForMultipleAttributeValues(base, filter, params, attributeNames);
        HashSet<String> result = new HashSet<String>();
        for (Map<String, List<String>> map : multipleAttributeValues) {
            List<String> values = map.get(attributeName);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public Set<Map<String, List<String>>> searchForMultipleAttributeValues(String base, String filter, Object[] params, String[] attributeNames) {
        Object[] encodedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            encodedParams[i] = LdapEncoder.filterEncode(params[i].toString());
        }
        String formattedFilter = MessageFormat.format(filter, encodedParams);
        logger.debug((Object)("Using filter: " + formattedFilter));
        HashSet<Map<String, List<String>>> set = new HashSet<Map<String, List<String>>>();
        ContextMapper roleMapper = ctx -> {
            DirContextAdapter adapter = (DirContextAdapter)ctx;
            HashMap<String, List<String>> record = new HashMap<String, List<String>>();
            if (attributeNames == null || attributeNames.length == 0) {
                try {
                    NamingEnumeration<? extends Attribute> ae = adapter.getAttributes().getAll();
                    while (ae.hasMore()) {
                        Attribute attr = ae.next();
                        this.extractStringAttributeValues(adapter, record, attr.getID());
                    }
                }
                catch (NamingException x) {
                    org.springframework.ldap.support.LdapUtils.convertLdapException((NamingException)x);
                }
            } else {
                for (String attributeName : attributeNames) {
                    this.extractStringAttributeValues(adapter, record, attributeName);
                }
            }
            record.put(DN_KEY, Arrays.asList(this.getAdapterDN(adapter)));
            set.add(record);
            return null;
        };
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(this.searchControls.getSearchScope());
        ctls.setReturningAttributes(attributeNames != null && attributeNames.length > 0 ? attributeNames : null);
        this.search(base, formattedFilter, ctls, roleMapper);
        return set;
    }

    private String getAdapterDN(DirContextAdapter adapter) {
        return adapter.getNameInNamespace();
    }

    private void extractStringAttributeValues(DirContextAdapter adapter, Map<String, List<String>> record, String attributeName) {
        Object[] values = adapter.getObjectAttributes(attributeName);
        if (values == null || values.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No attribute value found for '" + attributeName + "'"));
            }
            return;
        }
        ArrayList<String> svalues = new ArrayList<String>();
        for (Object o : values) {
            if (o == null) continue;
            if (String.class.isAssignableFrom(o.getClass())) {
                svalues.add((String)o);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attribute:" + attributeName + " contains a non string value of type[" + o.getClass() + "]"));
            }
            svalues.add(o.toString());
        }
        record.put(attributeName, svalues);
    }

    public DirContextOperations searchForSingleEntry(String base, String filter, Object[] params) {
        return (DirContextOperations)this.executeReadOnly(ctx -> SpringSecurityLdapTemplate.searchForSingleEntryInternal(ctx, this.searchControls, base, filter, params));
    }

    public static DirContextOperations searchForSingleEntryInternal(DirContext ctx, SearchControls searchControls, String base, String filter, Object[] params) throws NamingException {
        DistinguishedName ctxBaseDn = new DistinguishedName(ctx.getNameInNamespace());
        DistinguishedName searchBaseDn = new DistinguishedName(base);
        NamingEnumeration<SearchResult> resultsEnum = ctx.search((Name)searchBaseDn, filter, params, SpringSecurityLdapTemplate.buildControls(searchControls));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for entry under DN '" + ctxBaseDn + "', base = '" + searchBaseDn + "', filter = '" + filter + "'"));
        }
        HashSet<DirContextAdapter> results = new HashSet<DirContextAdapter>();
        try {
            while (resultsEnum.hasMore()) {
                SearchResult searchResult = resultsEnum.next();
                DirContextAdapter dca = (DirContextAdapter)searchResult.getObject();
                Assert.notNull((Object)dca, (String)"No object returned by search, DirContext is not correctly configured");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found DN: " + dca.getDn()));
                }
                results.add(dca);
            }
        }
        catch (PartialResultException e) {
            LdapUtils.closeEnumeration(resultsEnum);
            logger.info((Object)"Ignoring PartialResultException");
        }
        if (results.size() == 0) {
            throw new IncorrectResultSizeDataAccessException(1, 0);
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return (DirContextOperations)results.iterator().next();
    }

    private static SearchControls buildControls(SearchControls originalControls) {
        return new SearchControls(originalControls.getSearchScope(), originalControls.getCountLimit(), originalControls.getTimeLimit(), originalControls.getReturningAttributes(), true, originalControls.getDerefLinkFlag());
    }

    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }
}

