/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractLdapAuthenticationProvider
implements AuthenticationProvider,
MessageSourceAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private boolean useAuthenticationRequestCredentials = true;
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();
    protected UserDetailsContextMapper userDetailsContextMapper = new LdapUserDetailsMapper();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, () -> this.messages.getMessage("LdapAuthenticationProvider.onlySupports", "Only UsernamePasswordAuthenticationToken is supported"));
        UsernamePasswordAuthenticationToken userToken = (UsernamePasswordAuthenticationToken)authentication;
        String username = userToken.getName();
        String password = (String)authentication.getCredentials();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing authentication request for user: " + username));
        }
        if (!StringUtils.hasLength((String)username)) {
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.emptyUsername", "Empty Username"));
        }
        if (!StringUtils.hasLength((String)password)) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractLdapAuthenticationProvider.emptyPassword", "Empty Password"));
        }
        Assert.notNull((Object)password, (String)"Null password was supplied in authentication token");
        DirContextOperations userData = this.doAuthentication(userToken);
        UserDetails user = this.userDetailsContextMapper.mapUserFromContext(userData, authentication.getName(), this.loadUserAuthorities(userData, authentication.getName(), (String)authentication.getCredentials()));
        return this.createSuccessfulAuthentication(userToken, user);
    }

    protected abstract DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken var1);

    protected abstract Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations var1, String var2, String var3);

    protected Authentication createSuccessfulAuthentication(UsernamePasswordAuthenticationToken authentication, UserDetails user) {
        Object password = this.useAuthenticationRequestCredentials ? authentication.getCredentials() : user.getPassword();
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)user, password, this.authoritiesMapper.mapAuthorities(user.getAuthorities()));
        result.setDetails(authentication.getDetails());
        return result;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setUseAuthenticationRequestCredentials(boolean useAuthenticationRequestCredentials) {
        this.useAuthenticationRequestCredentials = useAuthenticationRequestCredentials;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    public void setUserDetailsContextMapper(UserDetailsContextMapper userDetailsContextMapper) {
        Assert.notNull((Object)userDetailsContextMapper, (String)"UserDetailsContextMapper must not be null");
        this.userDetailsContextMapper = userDetailsContextMapper;
    }

    protected UserDetailsContextMapper getUserDetailsContextMapper() {
        return this.userDetailsContextMapper;
    }
}

