/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.AbstractMessageMatcherComposite;
import org.springframework.security.messaging.util.matcher.MessageMatcher;

public final class AndMessageMatcher<T>
extends AbstractMessageMatcherComposite<T> {
    public AndMessageMatcher(List<MessageMatcher<T>> messageMatchers) {
        super(messageMatchers);
    }

    @SafeVarargs
    public AndMessageMatcher(MessageMatcher<T> ... messageMatchers) {
        super(messageMatchers);
    }

    @Override
    public boolean matches(Message<? extends T> message) {
        for (MessageMatcher matcher : this.getMessageMatchers()) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("Trying to match using " + matcher));
            }
            if (matcher.matches(message)) continue;
            this.LOGGER.debug((Object)"Did not match");
            return false;
        }
        this.LOGGER.debug((Object)"All messageMatchers returned true");
        return true;
    }
}

