/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.expression;

import java.util.Collection;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.messaging.Message;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.MessageExpressionConfigAttribute;
import org.springframework.util.Assert;

public class MessageExpressionVoter<T>
implements AccessDecisionVoter<Message<T>> {
    private SecurityExpressionHandler<Message<T>> expressionHandler = new DefaultMessageSecurityExpressionHandler();

    public int vote(Authentication authentication, Message<T> message, Collection<ConfigAttribute> attributes) {
        assert (authentication != null);
        assert (message != null);
        assert (attributes != null);
        MessageExpressionConfigAttribute attr = this.findConfigAttribute(attributes);
        if (attr == null) {
            return 0;
        }
        EvaluationContext ctx = this.expressionHandler.createEvaluationContext(authentication, message);
        return ExpressionUtils.evaluateAsBoolean((Expression)attr.getAuthorizeExpression(), (EvaluationContext)ctx) ? 1 : -1;
    }

    private MessageExpressionConfigAttribute findConfigAttribute(Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attribute : attributes) {
            if (!(attribute instanceof MessageExpressionConfigAttribute)) continue;
            return (MessageExpressionConfigAttribute)attribute;
        }
        return null;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof MessageExpressionConfigAttribute;
    }

    public boolean supports(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }

    public void setExpressionHandler(SecurityExpressionHandler<Message<T>> expressionHandler) {
        Assert.notNull(expressionHandler, (String)"expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
    }
}

